package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{
  SubnetId,
  BooleanObject,
  WorkspaceId,
  ComputerName,
  IpAddress,
  Description,
  WorkspaceErrorCode,
  BundleId,
  UserName,
  DirectoryId,
  VolumeEncryptionKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Workspace(
    workspaceId: Option[WorkspaceId] = None,
    directoryId: Option[DirectoryId] = None,
    userName: Option[UserName] = None,
    ipAddress: Option[IpAddress] = None,
    state: Option[zio.aws.workspaces.model.WorkspaceState] = None,
    bundleId: Option[BundleId] = None,
    subnetId: Option[SubnetId] = None,
    errorMessage: Option[Description] = None,
    errorCode: Option[WorkspaceErrorCode] = None,
    computerName: Option[ComputerName] = None,
    volumeEncryptionKey: Option[VolumeEncryptionKey] = None,
    userVolumeEncryptionEnabled: Option[BooleanObject] = None,
    rootVolumeEncryptionEnabled: Option[BooleanObject] = None,
    workspaceProperties: Option[zio.aws.workspaces.model.WorkspaceProperties] =
      None,
    modificationStates: Option[
      Iterable[zio.aws.workspaces.model.ModificationState]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.Workspace = {
    import Workspace.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.Workspace
      .builder()
      .optionallyWith(
        workspaceId.map(value => WorkspaceId.unwrap(value): java.lang.String)
      )(_.workspaceId)
      .optionallyWith(
        directoryId.map(value => DirectoryId.unwrap(value): java.lang.String)
      )(_.directoryId)
      .optionallyWith(
        userName.map(value => UserName.unwrap(value): java.lang.String)
      )(_.userName)
      .optionallyWith(
        ipAddress.map(value => IpAddress.unwrap(value): java.lang.String)
      )(_.ipAddress)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        bundleId.map(value => BundleId.unwrap(value): java.lang.String)
      )(_.bundleId)
      .optionallyWith(
        subnetId.map(value => SubnetId.unwrap(value): java.lang.String)
      )(_.subnetId)
      .optionallyWith(
        errorMessage.map(value => Description.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .optionallyWith(
        errorCode.map(value =>
          WorkspaceErrorCode.unwrap(value): java.lang.String
        )
      )(_.errorCode)
      .optionallyWith(
        computerName.map(value => ComputerName.unwrap(value): java.lang.String)
      )(_.computerName)
      .optionallyWith(
        volumeEncryptionKey.map(value =>
          VolumeEncryptionKey.unwrap(value): java.lang.String
        )
      )(_.volumeEncryptionKey)
      .optionallyWith(
        userVolumeEncryptionEnabled.map(value => value: java.lang.Boolean)
      )(_.userVolumeEncryptionEnabled)
      .optionallyWith(
        rootVolumeEncryptionEnabled.map(value => value: java.lang.Boolean)
      )(_.rootVolumeEncryptionEnabled)
      .optionallyWith(workspaceProperties.map(value => value.buildAwsValue()))(
        _.workspaceProperties
      )
      .optionallyWith(
        modificationStates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.modificationStates)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.Workspace.ReadOnly =
    zio.aws.workspaces.model.Workspace.wrap(buildAwsValue())
}
object Workspace {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.Workspace
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.Workspace =
      zio.aws.workspaces.model.Workspace(
        workspaceId.map(value => value),
        directoryId.map(value => value),
        userName.map(value => value),
        ipAddress.map(value => value),
        state.map(value => value),
        bundleId.map(value => value),
        subnetId.map(value => value),
        errorMessage.map(value => value),
        errorCode.map(value => value),
        computerName.map(value => value),
        volumeEncryptionKey.map(value => value),
        userVolumeEncryptionEnabled.map(value => value),
        rootVolumeEncryptionEnabled.map(value => value),
        workspaceProperties.map(value => value.asEditable),
        modificationStates.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def workspaceId: Option[WorkspaceId]
    def directoryId: Option[DirectoryId]
    def userName: Option[UserName]
    def ipAddress: Option[IpAddress]
    def state: Option[zio.aws.workspaces.model.WorkspaceState]
    def bundleId: Option[BundleId]
    def subnetId: Option[SubnetId]
    def errorMessage: Option[Description]
    def errorCode: Option[WorkspaceErrorCode]
    def computerName: Option[ComputerName]
    def volumeEncryptionKey: Option[VolumeEncryptionKey]
    def userVolumeEncryptionEnabled: Option[BooleanObject]
    def rootVolumeEncryptionEnabled: Option[BooleanObject]
    def workspaceProperties
        : Option[zio.aws.workspaces.model.WorkspaceProperties.ReadOnly]
    def modificationStates
        : Option[List[zio.aws.workspaces.model.ModificationState.ReadOnly]]
    def getWorkspaceId: ZIO[Any, AwsError, WorkspaceId] =
      AwsError.unwrapOptionField("workspaceId", workspaceId)
    def getDirectoryId: ZIO[Any, AwsError, DirectoryId] =
      AwsError.unwrapOptionField("directoryId", directoryId)
    def getUserName: ZIO[Any, AwsError, UserName] =
      AwsError.unwrapOptionField("userName", userName)
    def getIpAddress: ZIO[Any, AwsError, IpAddress] =
      AwsError.unwrapOptionField("ipAddress", ipAddress)
    def getState: ZIO[Any, AwsError, zio.aws.workspaces.model.WorkspaceState] =
      AwsError.unwrapOptionField("state", state)
    def getBundleId: ZIO[Any, AwsError, BundleId] =
      AwsError.unwrapOptionField("bundleId", bundleId)
    def getSubnetId: ZIO[Any, AwsError, SubnetId] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getErrorMessage: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getErrorCode: ZIO[Any, AwsError, WorkspaceErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getComputerName: ZIO[Any, AwsError, ComputerName] =
      AwsError.unwrapOptionField("computerName", computerName)
    def getVolumeEncryptionKey: ZIO[Any, AwsError, VolumeEncryptionKey] =
      AwsError.unwrapOptionField("volumeEncryptionKey", volumeEncryptionKey)
    def getUserVolumeEncryptionEnabled: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField(
        "userVolumeEncryptionEnabled",
        userVolumeEncryptionEnabled
      )
    def getRootVolumeEncryptionEnabled: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField(
        "rootVolumeEncryptionEnabled",
        rootVolumeEncryptionEnabled
      )
    def getWorkspaceProperties: ZIO[
      Any,
      AwsError,
      zio.aws.workspaces.model.WorkspaceProperties.ReadOnly
    ] = AwsError.unwrapOptionField("workspaceProperties", workspaceProperties)
    def getModificationStates: ZIO[Any, AwsError, List[
      zio.aws.workspaces.model.ModificationState.ReadOnly
    ]] = AwsError.unwrapOptionField("modificationStates", modificationStates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.Workspace
  ) extends zio.aws.workspaces.model.Workspace.ReadOnly {
    override val workspaceId: Option[WorkspaceId] = scala
      .Option(impl.workspaceId())
      .map(value => zio.aws.workspaces.model.primitives.WorkspaceId(value))
    override val directoryId: Option[DirectoryId] = scala
      .Option(impl.directoryId())
      .map(value => zio.aws.workspaces.model.primitives.DirectoryId(value))
    override val userName: Option[UserName] = scala
      .Option(impl.userName())
      .map(value => zio.aws.workspaces.model.primitives.UserName(value))
    override val ipAddress: Option[IpAddress] = scala
      .Option(impl.ipAddress())
      .map(value => zio.aws.workspaces.model.primitives.IpAddress(value))
    override val state: Option[zio.aws.workspaces.model.WorkspaceState] = scala
      .Option(impl.state())
      .map(value => zio.aws.workspaces.model.WorkspaceState.wrap(value))
    override val bundleId: Option[BundleId] = scala
      .Option(impl.bundleId())
      .map(value => zio.aws.workspaces.model.primitives.BundleId(value))
    override val subnetId: Option[SubnetId] = scala
      .Option(impl.subnetId())
      .map(value => zio.aws.workspaces.model.primitives.SubnetId(value))
    override val errorMessage: Option[Description] = scala
      .Option(impl.errorMessage())
      .map(value => zio.aws.workspaces.model.primitives.Description(value))
    override val errorCode: Option[WorkspaceErrorCode] = scala
      .Option(impl.errorCode())
      .map(value =>
        zio.aws.workspaces.model.primitives.WorkspaceErrorCode(value)
      )
    override val computerName: Option[ComputerName] = scala
      .Option(impl.computerName())
      .map(value => zio.aws.workspaces.model.primitives.ComputerName(value))
    override val volumeEncryptionKey: Option[VolumeEncryptionKey] = scala
      .Option(impl.volumeEncryptionKey())
      .map(value =>
        zio.aws.workspaces.model.primitives.VolumeEncryptionKey(value)
      )
    override val userVolumeEncryptionEnabled: Option[BooleanObject] = scala
      .Option(impl.userVolumeEncryptionEnabled())
      .map(value => value: BooleanObject)
    override val rootVolumeEncryptionEnabled: Option[BooleanObject] = scala
      .Option(impl.rootVolumeEncryptionEnabled())
      .map(value => value: BooleanObject)
    override val workspaceProperties
        : Option[zio.aws.workspaces.model.WorkspaceProperties.ReadOnly] = scala
      .Option(impl.workspaceProperties())
      .map(value => zio.aws.workspaces.model.WorkspaceProperties.wrap(value))
    override val modificationStates
        : Option[List[zio.aws.workspaces.model.ModificationState.ReadOnly]] =
      scala
        .Option(impl.modificationStates())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspaces.model.ModificationState.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.Workspace
  ): zio.aws.workspaces.model.Workspace.ReadOnly = new Wrapper(impl)
}
