package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UserStorage(capacity: Option[NonEmptyString] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.UserStorage = {
    import UserStorage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.UserStorage
      .builder()
      .optionallyWith(
        capacity.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.capacity)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.UserStorage.ReadOnly =
    zio.aws.workspaces.model.UserStorage.wrap(buildAwsValue())
}
object UserStorage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.UserStorage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.UserStorage =
      zio.aws.workspaces.model.UserStorage(capacity.map(value => value))
    def capacity: Option[NonEmptyString]
    def getCapacity: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("capacity", capacity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.UserStorage
  ) extends zio.aws.workspaces.model.UserStorage.ReadOnly {
    override val capacity: Option[NonEmptyString] = scala
      .Option(impl.capacity())
      .map(value => zio.aws.workspaces.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.UserStorage
  ): zio.aws.workspaces.model.UserStorage.ReadOnly = new Wrapper(impl)
}
