package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{WorkspaceImageId, BundleId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateWorkspaceBundleRequest(
    bundleId: Option[BundleId] = None,
    imageId: Option[WorkspaceImageId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.UpdateWorkspaceBundleRequest = {
    import UpdateWorkspaceBundleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.UpdateWorkspaceBundleRequest
      .builder()
      .optionallyWith(
        bundleId.map(value => BundleId.unwrap(value): java.lang.String)
      )(_.bundleId)
      .optionallyWith(
        imageId.map(value => WorkspaceImageId.unwrap(value): java.lang.String)
      )(_.imageId)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.UpdateWorkspaceBundleRequest.ReadOnly =
    zio.aws.workspaces.model.UpdateWorkspaceBundleRequest.wrap(buildAwsValue())
}
object UpdateWorkspaceBundleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.UpdateWorkspaceBundleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.UpdateWorkspaceBundleRequest =
      zio.aws.workspaces.model.UpdateWorkspaceBundleRequest(
        bundleId.map(value => value),
        imageId.map(value => value)
      )
    def bundleId: Option[BundleId]
    def imageId: Option[WorkspaceImageId]
    def getBundleId: ZIO[Any, AwsError, BundleId] =
      AwsError.unwrapOptionField("bundleId", bundleId)
    def getImageId: ZIO[Any, AwsError, WorkspaceImageId] =
      AwsError.unwrapOptionField("imageId", imageId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.UpdateWorkspaceBundleRequest
  ) extends zio.aws.workspaces.model.UpdateWorkspaceBundleRequest.ReadOnly {
    override val bundleId: Option[BundleId] = scala
      .Option(impl.bundleId())
      .map(value => zio.aws.workspaces.model.primitives.BundleId(value))
    override val imageId: Option[WorkspaceImageId] = scala
      .Option(impl.imageId())
      .map(value => zio.aws.workspaces.model.primitives.WorkspaceImageId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.UpdateWorkspaceBundleRequest
  ): zio.aws.workspaces.model.UpdateWorkspaceBundleRequest.ReadOnly =
    new Wrapper(impl)
}
