package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.IpGroupId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateRulesOfIpGroupRequest(
    groupId: IpGroupId,
    userRules: Iterable[zio.aws.workspaces.model.IpRuleItem]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.UpdateRulesOfIpGroupRequest = {
    import UpdateRulesOfIpGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.UpdateRulesOfIpGroupRequest
      .builder()
      .groupId(IpGroupId.unwrap(groupId): java.lang.String)
      .userRules(userRules.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.UpdateRulesOfIpGroupRequest.ReadOnly =
    zio.aws.workspaces.model.UpdateRulesOfIpGroupRequest.wrap(buildAwsValue())
}
object UpdateRulesOfIpGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.UpdateRulesOfIpGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.UpdateRulesOfIpGroupRequest =
      zio.aws.workspaces.model.UpdateRulesOfIpGroupRequest(
        groupId,
        userRules.map { item =>
          item.asEditable
        }
      )
    def groupId: IpGroupId
    def userRules: List[zio.aws.workspaces.model.IpRuleItem.ReadOnly]
    def getGroupId: ZIO[Any, Nothing, IpGroupId] = ZIO.succeed(groupId)
    def getUserRules: ZIO[Any, Nothing, List[
      zio.aws.workspaces.model.IpRuleItem.ReadOnly
    ]] = ZIO.succeed(userRules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.UpdateRulesOfIpGroupRequest
  ) extends zio.aws.workspaces.model.UpdateRulesOfIpGroupRequest.ReadOnly {
    override val groupId: IpGroupId =
      zio.aws.workspaces.model.primitives.IpGroupId(impl.groupId())
    override val userRules: List[zio.aws.workspaces.model.IpRuleItem.ReadOnly] =
      impl
        .userRules()
        .asScala
        .map { item =>
          zio.aws.workspaces.model.IpRuleItem.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.UpdateRulesOfIpGroupRequest
  ): zio.aws.workspaces.model.UpdateRulesOfIpGroupRequest.ReadOnly =
    new Wrapper(impl)
}
