package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.WorkspaceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StartRequest(workspaceId: Option[WorkspaceId] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.StartRequest = {
    import StartRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.StartRequest
      .builder()
      .optionallyWith(
        workspaceId.map(value => WorkspaceId.unwrap(value): java.lang.String)
      )(_.workspaceId)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.StartRequest.ReadOnly =
    zio.aws.workspaces.model.StartRequest.wrap(buildAwsValue())
}
object StartRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.StartRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.StartRequest =
      zio.aws.workspaces.model.StartRequest(workspaceId.map(value => value))
    def workspaceId: Option[WorkspaceId]
    def getWorkspaceId: ZIO[Any, AwsError, WorkspaceId] =
      AwsError.unwrapOptionField("workspaceId", workspaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.StartRequest
  ) extends zio.aws.workspaces.model.StartRequest.ReadOnly {
    override val workspaceId: Option[WorkspaceId] = scala
      .Option(impl.workspaceId())
      .map(value => zio.aws.workspaces.model.primitives.WorkspaceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.StartRequest
  ): zio.aws.workspaces.model.StartRequest.ReadOnly = new Wrapper(impl)
}
