package zio.aws.workspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SelfservicePermissions(
    restartWorkspace: Option[zio.aws.workspaces.model.ReconnectEnum] = None,
    increaseVolumeSize: Option[zio.aws.workspaces.model.ReconnectEnum] = None,
    changeComputeType: Option[zio.aws.workspaces.model.ReconnectEnum] = None,
    switchRunningMode: Option[zio.aws.workspaces.model.ReconnectEnum] = None,
    rebuildWorkspace: Option[zio.aws.workspaces.model.ReconnectEnum] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.SelfservicePermissions = {
    import SelfservicePermissions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.SelfservicePermissions
      .builder()
      .optionallyWith(restartWorkspace.map(value => value.unwrap))(
        _.restartWorkspace
      )
      .optionallyWith(increaseVolumeSize.map(value => value.unwrap))(
        _.increaseVolumeSize
      )
      .optionallyWith(changeComputeType.map(value => value.unwrap))(
        _.changeComputeType
      )
      .optionallyWith(switchRunningMode.map(value => value.unwrap))(
        _.switchRunningMode
      )
      .optionallyWith(rebuildWorkspace.map(value => value.unwrap))(
        _.rebuildWorkspace
      )
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.SelfservicePermissions.ReadOnly =
    zio.aws.workspaces.model.SelfservicePermissions.wrap(buildAwsValue())
}
object SelfservicePermissions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.SelfservicePermissions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.SelfservicePermissions =
      zio.aws.workspaces.model.SelfservicePermissions(
        restartWorkspace.map(value => value),
        increaseVolumeSize.map(value => value),
        changeComputeType.map(value => value),
        switchRunningMode.map(value => value),
        rebuildWorkspace.map(value => value)
      )
    def restartWorkspace: Option[zio.aws.workspaces.model.ReconnectEnum]
    def increaseVolumeSize: Option[zio.aws.workspaces.model.ReconnectEnum]
    def changeComputeType: Option[zio.aws.workspaces.model.ReconnectEnum]
    def switchRunningMode: Option[zio.aws.workspaces.model.ReconnectEnum]
    def rebuildWorkspace: Option[zio.aws.workspaces.model.ReconnectEnum]
    def getRestartWorkspace
        : ZIO[Any, AwsError, zio.aws.workspaces.model.ReconnectEnum] =
      AwsError.unwrapOptionField("restartWorkspace", restartWorkspace)
    def getIncreaseVolumeSize
        : ZIO[Any, AwsError, zio.aws.workspaces.model.ReconnectEnum] =
      AwsError.unwrapOptionField("increaseVolumeSize", increaseVolumeSize)
    def getChangeComputeType
        : ZIO[Any, AwsError, zio.aws.workspaces.model.ReconnectEnum] =
      AwsError.unwrapOptionField("changeComputeType", changeComputeType)
    def getSwitchRunningMode
        : ZIO[Any, AwsError, zio.aws.workspaces.model.ReconnectEnum] =
      AwsError.unwrapOptionField("switchRunningMode", switchRunningMode)
    def getRebuildWorkspace
        : ZIO[Any, AwsError, zio.aws.workspaces.model.ReconnectEnum] =
      AwsError.unwrapOptionField("rebuildWorkspace", rebuildWorkspace)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.SelfservicePermissions
  ) extends zio.aws.workspaces.model.SelfservicePermissions.ReadOnly {
    override val restartWorkspace
        : Option[zio.aws.workspaces.model.ReconnectEnum] = scala
      .Option(impl.restartWorkspace())
      .map(value => zio.aws.workspaces.model.ReconnectEnum.wrap(value))
    override val increaseVolumeSize
        : Option[zio.aws.workspaces.model.ReconnectEnum] = scala
      .Option(impl.increaseVolumeSize())
      .map(value => zio.aws.workspaces.model.ReconnectEnum.wrap(value))
    override val changeComputeType
        : Option[zio.aws.workspaces.model.ReconnectEnum] = scala
      .Option(impl.changeComputeType())
      .map(value => zio.aws.workspaces.model.ReconnectEnum.wrap(value))
    override val switchRunningMode
        : Option[zio.aws.workspaces.model.ReconnectEnum] = scala
      .Option(impl.switchRunningMode())
      .map(value => zio.aws.workspaces.model.ReconnectEnum.wrap(value))
    override val rebuildWorkspace
        : Option[zio.aws.workspaces.model.ReconnectEnum] = scala
      .Option(impl.rebuildWorkspace())
      .map(value => zio.aws.workspaces.model.ReconnectEnum.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.SelfservicePermissions
  ): zio.aws.workspaces.model.SelfservicePermissions.ReadOnly = new Wrapper(
    impl
  )
}
