package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{IpRule, IpGroupId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RevokeIpRulesRequest(
    groupId: IpGroupId,
    userRules: Iterable[IpRule]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.RevokeIpRulesRequest = {
    import RevokeIpRulesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.RevokeIpRulesRequest
      .builder()
      .groupId(IpGroupId.unwrap(groupId): java.lang.String)
      .userRules(userRules.map { item =>
        IpRule.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.RevokeIpRulesRequest.ReadOnly =
    zio.aws.workspaces.model.RevokeIpRulesRequest.wrap(buildAwsValue())
}
object RevokeIpRulesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.RevokeIpRulesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.RevokeIpRulesRequest =
      zio.aws.workspaces.model.RevokeIpRulesRequest(groupId, userRules)
    def groupId: IpGroupId
    def userRules: List[IpRule]
    def getGroupId: ZIO[Any, Nothing, IpGroupId] = ZIO.succeed(groupId)
    def getUserRules: ZIO[Any, Nothing, List[IpRule]] = ZIO.succeed(userRules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.RevokeIpRulesRequest
  ) extends zio.aws.workspaces.model.RevokeIpRulesRequest.ReadOnly {
    override val groupId: IpGroupId =
      zio.aws.workspaces.model.primitives.IpGroupId(impl.groupId())
    override val userRules: List[IpRule] = impl
      .userRules()
      .asScala
      .map { item =>
        zio.aws.workspaces.model.primitives.IpRule(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.RevokeIpRulesRequest
  ): zio.aws.workspaces.model.RevokeIpRulesRequest.ReadOnly = new Wrapper(impl)
}
