package zio.aws.workspaces.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RebootWorkspacesRequest(
    rebootWorkspaceRequests: Iterable[zio.aws.workspaces.model.RebootRequest]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.RebootWorkspacesRequest = {
    import RebootWorkspacesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.RebootWorkspacesRequest
      .builder()
      .rebootWorkspaceRequests(rebootWorkspaceRequests.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.RebootWorkspacesRequest.ReadOnly =
    zio.aws.workspaces.model.RebootWorkspacesRequest.wrap(buildAwsValue())
}
object RebootWorkspacesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.RebootWorkspacesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.RebootWorkspacesRequest =
      zio.aws.workspaces.model
        .RebootWorkspacesRequest(rebootWorkspaceRequests.map { item =>
          item.asEditable
        })
    def rebootWorkspaceRequests
        : List[zio.aws.workspaces.model.RebootRequest.ReadOnly]
    def getRebootWorkspaceRequests: ZIO[Any, Nothing, List[
      zio.aws.workspaces.model.RebootRequest.ReadOnly
    ]] = ZIO.succeed(rebootWorkspaceRequests)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.RebootWorkspacesRequest
  ) extends zio.aws.workspaces.model.RebootWorkspacesRequest.ReadOnly {
    override val rebootWorkspaceRequests
        : List[zio.aws.workspaces.model.RebootRequest.ReadOnly] = impl
      .rebootWorkspaceRequests()
      .asScala
      .map { item =>
        zio.aws.workspaces.model.RebootRequest.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.RebootWorkspacesRequest
  ): zio.aws.workspaces.model.RebootWorkspacesRequest.ReadOnly = new Wrapper(
    impl
  )
}
