package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.DirectoryId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ModifyWorkspaceCreationPropertiesRequest(
    resourceId: DirectoryId,
    workspaceCreationProperties: zio.aws.workspaces.model.WorkspaceCreationProperties
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceCreationPropertiesRequest = {
    import ModifyWorkspaceCreationPropertiesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceCreationPropertiesRequest
      .builder()
      .resourceId(DirectoryId.unwrap(resourceId): java.lang.String)
      .workspaceCreationProperties(workspaceCreationProperties.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.ModifyWorkspaceCreationPropertiesRequest.ReadOnly =
    zio.aws.workspaces.model.ModifyWorkspaceCreationPropertiesRequest
      .wrap(buildAwsValue())
}
object ModifyWorkspaceCreationPropertiesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceCreationPropertiesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspaces.model.ModifyWorkspaceCreationPropertiesRequest =
      zio.aws.workspaces.model.ModifyWorkspaceCreationPropertiesRequest(
        resourceId,
        workspaceCreationProperties.asEditable
      )
    def resourceId: DirectoryId
    def workspaceCreationProperties
        : zio.aws.workspaces.model.WorkspaceCreationProperties.ReadOnly
    def getResourceId: ZIO[Any, Nothing, DirectoryId] = ZIO.succeed(resourceId)
    def getWorkspaceCreationProperties: ZIO[
      Any,
      Nothing,
      zio.aws.workspaces.model.WorkspaceCreationProperties.ReadOnly
    ] = ZIO.succeed(workspaceCreationProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceCreationPropertiesRequest
  ) extends zio.aws.workspaces.model.ModifyWorkspaceCreationPropertiesRequest.ReadOnly {
    override val resourceId: DirectoryId =
      zio.aws.workspaces.model.primitives.DirectoryId(impl.resourceId())
    override val workspaceCreationProperties
        : zio.aws.workspaces.model.WorkspaceCreationProperties.ReadOnly =
      zio.aws.workspaces.model.WorkspaceCreationProperties
        .wrap(impl.workspaceCreationProperties())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceCreationPropertiesRequest
  ): zio.aws.workspaces.model.ModifyWorkspaceCreationPropertiesRequest.ReadOnly =
    new Wrapper(impl)
}
