package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.DedicatedTenancyManagementCidrRange
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ModifyAccountRequest(
    dedicatedTenancySupport: Option[
      zio.aws.workspaces.model.DedicatedTenancySupportEnum
    ] = None,
    dedicatedTenancyManagementCidrRange: Option[
      DedicatedTenancyManagementCidrRange
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.ModifyAccountRequest = {
    import ModifyAccountRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.ModifyAccountRequest
      .builder()
      .optionallyWith(dedicatedTenancySupport.map(value => value.unwrap))(
        _.dedicatedTenancySupport
      )
      .optionallyWith(
        dedicatedTenancyManagementCidrRange.map(value =>
          DedicatedTenancyManagementCidrRange.unwrap(value): java.lang.String
        )
      )(_.dedicatedTenancyManagementCidrRange)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.ModifyAccountRequest.ReadOnly =
    zio.aws.workspaces.model.ModifyAccountRequest.wrap(buildAwsValue())
}
object ModifyAccountRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.ModifyAccountRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.ModifyAccountRequest =
      zio.aws.workspaces.model.ModifyAccountRequest(
        dedicatedTenancySupport.map(value => value),
        dedicatedTenancyManagementCidrRange.map(value => value)
      )
    def dedicatedTenancySupport
        : Option[zio.aws.workspaces.model.DedicatedTenancySupportEnum]
    def dedicatedTenancyManagementCidrRange
        : Option[DedicatedTenancyManagementCidrRange]
    def getDedicatedTenancySupport: ZIO[
      Any,
      AwsError,
      zio.aws.workspaces.model.DedicatedTenancySupportEnum
    ] = AwsError.unwrapOptionField(
      "dedicatedTenancySupport",
      dedicatedTenancySupport
    )
    def getDedicatedTenancyManagementCidrRange
        : ZIO[Any, AwsError, DedicatedTenancyManagementCidrRange] =
      AwsError.unwrapOptionField(
        "dedicatedTenancyManagementCidrRange",
        dedicatedTenancyManagementCidrRange
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.ModifyAccountRequest
  ) extends zio.aws.workspaces.model.ModifyAccountRequest.ReadOnly {
    override val dedicatedTenancySupport
        : Option[zio.aws.workspaces.model.DedicatedTenancySupportEnum] = scala
      .Option(impl.dedicatedTenancySupport())
      .map(value =>
        zio.aws.workspaces.model.DedicatedTenancySupportEnum.wrap(value)
      )
    override val dedicatedTenancyManagementCidrRange
        : Option[DedicatedTenancyManagementCidrRange] = scala
      .Option(impl.dedicatedTenancyManagementCidrRange())
      .map(value =>
        zio.aws.workspaces.model.primitives
          .DedicatedTenancyManagementCidrRange(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.ModifyAccountRequest
  ): zio.aws.workspaces.model.ModifyAccountRequest.ReadOnly = new Wrapper(impl)
}
