package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{
  WorkspaceImageDescription,
  WorkspaceImageName,
  Ec2ImageId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ImportWorkspaceImageRequest(
    ec2ImageId: Ec2ImageId,
    ingestionProcess: zio.aws.workspaces.model.WorkspaceImageIngestionProcess,
    imageName: WorkspaceImageName,
    imageDescription: WorkspaceImageDescription,
    tags: Option[Iterable[zio.aws.workspaces.model.Tag]] = None,
    applications: Option[Iterable[zio.aws.workspaces.model.Application]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.ImportWorkspaceImageRequest = {
    import ImportWorkspaceImageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.ImportWorkspaceImageRequest
      .builder()
      .ec2ImageId(Ec2ImageId.unwrap(ec2ImageId): java.lang.String)
      .ingestionProcess(ingestionProcess.unwrap)
      .imageName(WorkspaceImageName.unwrap(imageName): java.lang.String)
      .imageDescription(
        WorkspaceImageDescription.unwrap(imageDescription): java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        applications.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.applicationsWithStrings)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.ImportWorkspaceImageRequest.ReadOnly =
    zio.aws.workspaces.model.ImportWorkspaceImageRequest.wrap(buildAwsValue())
}
object ImportWorkspaceImageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.ImportWorkspaceImageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.ImportWorkspaceImageRequest =
      zio.aws.workspaces.model.ImportWorkspaceImageRequest(
        ec2ImageId,
        ingestionProcess,
        imageName,
        imageDescription,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        applications.map(value => value)
      )
    def ec2ImageId: Ec2ImageId
    def ingestionProcess
        : zio.aws.workspaces.model.WorkspaceImageIngestionProcess
    def imageName: WorkspaceImageName
    def imageDescription: WorkspaceImageDescription
    def tags: Option[List[zio.aws.workspaces.model.Tag.ReadOnly]]
    def applications: Option[List[zio.aws.workspaces.model.Application]]
    def getEc2ImageId: ZIO[Any, Nothing, Ec2ImageId] = ZIO.succeed(ec2ImageId)
    def getIngestionProcess: ZIO[
      Any,
      Nothing,
      zio.aws.workspaces.model.WorkspaceImageIngestionProcess
    ] = ZIO.succeed(ingestionProcess)
    def getImageName: ZIO[Any, Nothing, WorkspaceImageName] =
      ZIO.succeed(imageName)
    def getImageDescription: ZIO[Any, Nothing, WorkspaceImageDescription] =
      ZIO.succeed(imageDescription)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.workspaces.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getApplications
        : ZIO[Any, AwsError, List[zio.aws.workspaces.model.Application]] =
      AwsError.unwrapOptionField("applications", applications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.ImportWorkspaceImageRequest
  ) extends zio.aws.workspaces.model.ImportWorkspaceImageRequest.ReadOnly {
    override val ec2ImageId: Ec2ImageId =
      zio.aws.workspaces.model.primitives.Ec2ImageId(impl.ec2ImageId())
    override val ingestionProcess
        : zio.aws.workspaces.model.WorkspaceImageIngestionProcess =
      zio.aws.workspaces.model.WorkspaceImageIngestionProcess
        .wrap(impl.ingestionProcess())
    override val imageName: WorkspaceImageName =
      zio.aws.workspaces.model.primitives.WorkspaceImageName(impl.imageName())
    override val imageDescription: WorkspaceImageDescription =
      zio.aws.workspaces.model.primitives
        .WorkspaceImageDescription(impl.imageDescription())
    override val tags: Option[List[zio.aws.workspaces.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspaces.model.Tag.wrap(item)
          }.toList
        )
    override val applications
        : Option[List[zio.aws.workspaces.model.Application]] = scala
      .Option(impl.applications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workspaces.model.Application.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.ImportWorkspaceImageRequest
  ): zio.aws.workspaces.model.ImportWorkspaceImageRequest.ReadOnly =
    new Wrapper(impl)
}
