package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeWorkspacesConnectionStatusResponse(
    workspacesConnectionStatus: Option[
      Iterable[zio.aws.workspaces.model.WorkspaceConnectionStatus]
    ] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesConnectionStatusResponse = {
    import DescribeWorkspacesConnectionStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesConnectionStatusResponse
      .builder()
      .optionallyWith(
        workspacesConnectionStatus.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.workspacesConnectionStatus)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.DescribeWorkspacesConnectionStatusResponse.ReadOnly =
    zio.aws.workspaces.model.DescribeWorkspacesConnectionStatusResponse
      .wrap(buildAwsValue())
}
object DescribeWorkspacesConnectionStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesConnectionStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspaces.model.DescribeWorkspacesConnectionStatusResponse =
      zio.aws.workspaces.model.DescribeWorkspacesConnectionStatusResponse(
        workspacesConnectionStatus.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def workspacesConnectionStatus: Option[
      List[zio.aws.workspaces.model.WorkspaceConnectionStatus.ReadOnly]
    ]
    def nextToken: Option[PaginationToken]
    def getWorkspacesConnectionStatus: ZIO[Any, AwsError, List[
      zio.aws.workspaces.model.WorkspaceConnectionStatus.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "workspacesConnectionStatus",
      workspacesConnectionStatus
    )
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesConnectionStatusResponse
  ) extends zio.aws.workspaces.model.DescribeWorkspacesConnectionStatusResponse.ReadOnly {
    override val workspacesConnectionStatus: Option[
      List[zio.aws.workspaces.model.WorkspaceConnectionStatus.ReadOnly]
    ] = scala
      .Option(impl.workspacesConnectionStatus())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workspaces.model.WorkspaceConnectionStatus.wrap(item)
        }.toList
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.workspaces.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesConnectionStatusResponse
  ): zio.aws.workspaces.model.DescribeWorkspacesConnectionStatusResponse.ReadOnly =
    new Wrapper(impl)
}
