package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{PaginationToken, WorkspaceId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeWorkspacesConnectionStatusRequest(
    workspaceIds: Option[Iterable[WorkspaceId]] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesConnectionStatusRequest = {
    import DescribeWorkspacesConnectionStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesConnectionStatusRequest
      .builder()
      .optionallyWith(
        workspaceIds.map(value =>
          value.map { item =>
            WorkspaceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.workspaceIds)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.DescribeWorkspacesConnectionStatusRequest.ReadOnly =
    zio.aws.workspaces.model.DescribeWorkspacesConnectionStatusRequest
      .wrap(buildAwsValue())
}
object DescribeWorkspacesConnectionStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesConnectionStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspaces.model.DescribeWorkspacesConnectionStatusRequest =
      zio.aws.workspaces.model.DescribeWorkspacesConnectionStatusRequest(
        workspaceIds.map(value => value),
        nextToken.map(value => value)
      )
    def workspaceIds: Option[List[WorkspaceId]]
    def nextToken: Option[PaginationToken]
    def getWorkspaceIds: ZIO[Any, AwsError, List[WorkspaceId]] =
      AwsError.unwrapOptionField("workspaceIds", workspaceIds)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesConnectionStatusRequest
  ) extends zio.aws.workspaces.model.DescribeWorkspacesConnectionStatusRequest.ReadOnly {
    override val workspaceIds: Option[List[WorkspaceId]] = scala
      .Option(impl.workspaceIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workspaces.model.primitives.WorkspaceId(item)
        }.toList
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.workspaces.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesConnectionStatusRequest
  ): zio.aws.workspaces.model.DescribeWorkspacesConnectionStatusRequest.ReadOnly =
    new Wrapper(impl)
}
