package zio.aws.workspaces.model
import java.lang.Integer
import zio.aws.workspaces.model.primitives.{
  Limit,
  PaginationToken,
  WorkspaceImageId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeWorkspaceImagesRequest(
    imageIds: Option[Iterable[WorkspaceImageId]] = None,
    imageType: Option[zio.aws.workspaces.model.ImageType] = None,
    nextToken: Option[PaginationToken] = None,
    maxResults: Option[Limit] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagesRequest = {
    import DescribeWorkspaceImagesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagesRequest
      .builder()
      .optionallyWith(
        imageIds.map(value =>
          value.map { item =>
            WorkspaceImageId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.imageIds)
      .optionallyWith(imageType.map(value => value.unwrap))(_.imageType)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(maxResults.map(value => Limit.unwrap(value): Integer))(
        _.maxResults
      )
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.DescribeWorkspaceImagesRequest.ReadOnly =
    zio.aws.workspaces.model.DescribeWorkspaceImagesRequest
      .wrap(buildAwsValue())
}
object DescribeWorkspaceImagesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.DescribeWorkspaceImagesRequest =
      zio.aws.workspaces.model.DescribeWorkspaceImagesRequest(
        imageIds.map(value => value),
        imageType.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def imageIds: Option[List[WorkspaceImageId]]
    def imageType: Option[zio.aws.workspaces.model.ImageType]
    def nextToken: Option[PaginationToken]
    def maxResults: Option[Limit]
    def getImageIds: ZIO[Any, AwsError, List[WorkspaceImageId]] =
      AwsError.unwrapOptionField("imageIds", imageIds)
    def getImageType: ZIO[Any, AwsError, zio.aws.workspaces.model.ImageType] =
      AwsError.unwrapOptionField("imageType", imageType)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, Limit] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagesRequest
  ) extends zio.aws.workspaces.model.DescribeWorkspaceImagesRequest.ReadOnly {
    override val imageIds: Option[List[WorkspaceImageId]] = scala
      .Option(impl.imageIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workspaces.model.primitives.WorkspaceImageId(item)
        }.toList
      )
    override val imageType: Option[zio.aws.workspaces.model.ImageType] = scala
      .Option(impl.imageType())
      .map(value => zio.aws.workspaces.model.ImageType.wrap(value))
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.workspaces.model.primitives.PaginationToken(value))
    override val maxResults: Option[Limit] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.workspaces.model.primitives.Limit(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagesRequest
  ): zio.aws.workspaces.model.DescribeWorkspaceImagesRequest.ReadOnly =
    new Wrapper(impl)
}
