package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{PaginationToken, WorkspaceImageId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeWorkspaceImagePermissionsResponse(
    imageId: Option[WorkspaceImageId] = None,
    imagePermissions: Option[
      Iterable[zio.aws.workspaces.model.ImagePermission]
    ] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagePermissionsResponse = {
    import DescribeWorkspaceImagePermissionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagePermissionsResponse
      .builder()
      .optionallyWith(
        imageId.map(value => WorkspaceImageId.unwrap(value): java.lang.String)
      )(_.imageId)
      .optionallyWith(
        imagePermissions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.imagePermissions)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.DescribeWorkspaceImagePermissionsResponse.ReadOnly =
    zio.aws.workspaces.model.DescribeWorkspaceImagePermissionsResponse
      .wrap(buildAwsValue())
}
object DescribeWorkspaceImagePermissionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagePermissionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspaces.model.DescribeWorkspaceImagePermissionsResponse =
      zio.aws.workspaces.model.DescribeWorkspaceImagePermissionsResponse(
        imageId.map(value => value),
        imagePermissions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def imageId: Option[WorkspaceImageId]
    def imagePermissions
        : Option[List[zio.aws.workspaces.model.ImagePermission.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getImageId: ZIO[Any, AwsError, WorkspaceImageId] =
      AwsError.unwrapOptionField("imageId", imageId)
    def getImagePermissions: ZIO[Any, AwsError, List[
      zio.aws.workspaces.model.ImagePermission.ReadOnly
    ]] = AwsError.unwrapOptionField("imagePermissions", imagePermissions)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagePermissionsResponse
  ) extends zio.aws.workspaces.model.DescribeWorkspaceImagePermissionsResponse.ReadOnly {
    override val imageId: Option[WorkspaceImageId] = scala
      .Option(impl.imageId())
      .map(value => zio.aws.workspaces.model.primitives.WorkspaceImageId(value))
    override val imagePermissions
        : Option[List[zio.aws.workspaces.model.ImagePermission.ReadOnly]] =
      scala
        .Option(impl.imagePermissions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspaces.model.ImagePermission.wrap(item)
          }.toList
        )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.workspaces.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagePermissionsResponse
  ): zio.aws.workspaces.model.DescribeWorkspaceImagePermissionsResponse.ReadOnly =
    new Wrapper(impl)
}
