package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeWorkspaceDirectoriesResponse(
    directories: Option[Iterable[zio.aws.workspaces.model.WorkspaceDirectory]] =
      None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesResponse = {
    import DescribeWorkspaceDirectoriesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesResponse
      .builder()
      .optionallyWith(
        directories.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.directories)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.DescribeWorkspaceDirectoriesResponse.ReadOnly =
    zio.aws.workspaces.model.DescribeWorkspaceDirectoriesResponse
      .wrap(buildAwsValue())
}
object DescribeWorkspaceDirectoriesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspaces.model.DescribeWorkspaceDirectoriesResponse =
      zio.aws.workspaces.model.DescribeWorkspaceDirectoriesResponse(
        directories.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def directories
        : Option[List[zio.aws.workspaces.model.WorkspaceDirectory.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getDirectories: ZIO[Any, AwsError, List[
      zio.aws.workspaces.model.WorkspaceDirectory.ReadOnly
    ]] = AwsError.unwrapOptionField("directories", directories)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesResponse
  ) extends zio.aws.workspaces.model.DescribeWorkspaceDirectoriesResponse.ReadOnly {
    override val directories
        : Option[List[zio.aws.workspaces.model.WorkspaceDirectory.ReadOnly]] =
      scala
        .Option(impl.directories())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspaces.model.WorkspaceDirectory.wrap(item)
          }.toList
        )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.workspaces.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesResponse
  ): zio.aws.workspaces.model.DescribeWorkspaceDirectoriesResponse.ReadOnly =
    new Wrapper(impl)
}
