package zio.aws.workspaces.model
import java.lang.Integer
import zio.aws.workspaces.model.primitives.{Limit, PaginationToken, DirectoryId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeConnectClientAddInsRequest(
    resourceId: DirectoryId,
    nextToken: Option[PaginationToken] = None,
    maxResults: Option[Limit] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DescribeConnectClientAddInsRequest = {
    import DescribeConnectClientAddInsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DescribeConnectClientAddInsRequest
      .builder()
      .resourceId(DirectoryId.unwrap(resourceId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(maxResults.map(value => Limit.unwrap(value): Integer))(
        _.maxResults
      )
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.DescribeConnectClientAddInsRequest.ReadOnly =
    zio.aws.workspaces.model.DescribeConnectClientAddInsRequest
      .wrap(buildAwsValue())
}
object DescribeConnectClientAddInsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DescribeConnectClientAddInsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspaces.model.DescribeConnectClientAddInsRequest =
      zio.aws.workspaces.model.DescribeConnectClientAddInsRequest(
        resourceId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def resourceId: DirectoryId
    def nextToken: Option[PaginationToken]
    def maxResults: Option[Limit]
    def getResourceId: ZIO[Any, Nothing, DirectoryId] = ZIO.succeed(resourceId)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, Limit] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeConnectClientAddInsRequest
  ) extends zio.aws.workspaces.model.DescribeConnectClientAddInsRequest.ReadOnly {
    override val resourceId: DirectoryId =
      zio.aws.workspaces.model.primitives.DirectoryId(impl.resourceId())
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.workspaces.model.primitives.PaginationToken(value))
    override val maxResults: Option[Limit] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.workspaces.model.primitives.Limit(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeConnectClientAddInsRequest
  ): zio.aws.workspaces.model.DescribeConnectClientAddInsRequest.ReadOnly =
    new Wrapper(impl)
}
