package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeClientPropertiesRequest(
    resourceIds: Iterable[NonEmptyString]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DescribeClientPropertiesRequest = {
    import DescribeClientPropertiesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DescribeClientPropertiesRequest
      .builder()
      .resourceIds(resourceIds.map { item =>
        NonEmptyString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.DescribeClientPropertiesRequest.ReadOnly =
    zio.aws.workspaces.model.DescribeClientPropertiesRequest
      .wrap(buildAwsValue())
}
object DescribeClientPropertiesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DescribeClientPropertiesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.DescribeClientPropertiesRequest =
      zio.aws.workspaces.model.DescribeClientPropertiesRequest(resourceIds)
    def resourceIds: List[NonEmptyString]
    def getResourceIds: ZIO[Any, Nothing, List[NonEmptyString]] =
      ZIO.succeed(resourceIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeClientPropertiesRequest
  ) extends zio.aws.workspaces.model.DescribeClientPropertiesRequest.ReadOnly {
    override val resourceIds: List[NonEmptyString] = impl
      .resourceIds()
      .asScala
      .map { item =>
        zio.aws.workspaces.model.primitives.NonEmptyString(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeClientPropertiesRequest
  ): zio.aws.workspaces.model.DescribeClientPropertiesRequest.ReadOnly =
    new Wrapper(impl)
}
