package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.DedicatedTenancyManagementCidrRange
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeAccountResponse(
    dedicatedTenancySupport: Option[
      zio.aws.workspaces.model.DedicatedTenancySupportResultEnum
    ] = None,
    dedicatedTenancyManagementCidrRange: Option[
      DedicatedTenancyManagementCidrRange
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DescribeAccountResponse = {
    import DescribeAccountResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DescribeAccountResponse
      .builder()
      .optionallyWith(dedicatedTenancySupport.map(value => value.unwrap))(
        _.dedicatedTenancySupport
      )
      .optionallyWith(
        dedicatedTenancyManagementCidrRange.map(value =>
          DedicatedTenancyManagementCidrRange.unwrap(value): java.lang.String
        )
      )(_.dedicatedTenancyManagementCidrRange)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.DescribeAccountResponse.ReadOnly =
    zio.aws.workspaces.model.DescribeAccountResponse.wrap(buildAwsValue())
}
object DescribeAccountResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DescribeAccountResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.DescribeAccountResponse =
      zio.aws.workspaces.model.DescribeAccountResponse(
        dedicatedTenancySupport.map(value => value),
        dedicatedTenancyManagementCidrRange.map(value => value)
      )
    def dedicatedTenancySupport
        : Option[zio.aws.workspaces.model.DedicatedTenancySupportResultEnum]
    def dedicatedTenancyManagementCidrRange
        : Option[DedicatedTenancyManagementCidrRange]
    def getDedicatedTenancySupport: ZIO[
      Any,
      AwsError,
      zio.aws.workspaces.model.DedicatedTenancySupportResultEnum
    ] = AwsError.unwrapOptionField(
      "dedicatedTenancySupport",
      dedicatedTenancySupport
    )
    def getDedicatedTenancyManagementCidrRange
        : ZIO[Any, AwsError, DedicatedTenancyManagementCidrRange] =
      AwsError.unwrapOptionField(
        "dedicatedTenancyManagementCidrRange",
        dedicatedTenancyManagementCidrRange
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeAccountResponse
  ) extends zio.aws.workspaces.model.DescribeAccountResponse.ReadOnly {
    override val dedicatedTenancySupport
        : Option[zio.aws.workspaces.model.DedicatedTenancySupportResultEnum] =
      scala
        .Option(impl.dedicatedTenancySupport())
        .map(value =>
          zio.aws.workspaces.model.DedicatedTenancySupportResultEnum.wrap(value)
        )
    override val dedicatedTenancyManagementCidrRange
        : Option[DedicatedTenancyManagementCidrRange] = scala
      .Option(impl.dedicatedTenancyManagementCidrRange())
      .map(value =>
        zio.aws.workspaces.model.primitives
          .DedicatedTenancyManagementCidrRange(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeAccountResponse
  ): zio.aws.workspaces.model.DescribeAccountResponse.ReadOnly = new Wrapper(
    impl
  )
}
