package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.DirectoryId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeregisterWorkspaceDirectoryRequest(directoryId: DirectoryId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DeregisterWorkspaceDirectoryRequest = {
    import DeregisterWorkspaceDirectoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DeregisterWorkspaceDirectoryRequest
      .builder()
      .directoryId(DirectoryId.unwrap(directoryId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.DeregisterWorkspaceDirectoryRequest.ReadOnly =
    zio.aws.workspaces.model.DeregisterWorkspaceDirectoryRequest
      .wrap(buildAwsValue())
}
object DeregisterWorkspaceDirectoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DeregisterWorkspaceDirectoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspaces.model.DeregisterWorkspaceDirectoryRequest =
      zio.aws.workspaces.model.DeregisterWorkspaceDirectoryRequest(directoryId)
    def directoryId: DirectoryId
    def getDirectoryId: ZIO[Any, Nothing, DirectoryId] =
      ZIO.succeed(directoryId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DeregisterWorkspaceDirectoryRequest
  ) extends zio.aws.workspaces.model.DeregisterWorkspaceDirectoryRequest.ReadOnly {
    override val directoryId: DirectoryId =
      zio.aws.workspaces.model.primitives.DirectoryId(impl.directoryId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DeregisterWorkspaceDirectoryRequest
  ): zio.aws.workspaces.model.DeregisterWorkspaceDirectoryRequest.ReadOnly =
    new Wrapper(impl)
}
