package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.WorkspaceImageId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateUpdatedWorkspaceImageResponse(
    imageId: Option[WorkspaceImageId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.CreateUpdatedWorkspaceImageResponse = {
    import CreateUpdatedWorkspaceImageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.CreateUpdatedWorkspaceImageResponse
      .builder()
      .optionallyWith(
        imageId.map(value => WorkspaceImageId.unwrap(value): java.lang.String)
      )(_.imageId)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.CreateUpdatedWorkspaceImageResponse.ReadOnly =
    zio.aws.workspaces.model.CreateUpdatedWorkspaceImageResponse
      .wrap(buildAwsValue())
}
object CreateUpdatedWorkspaceImageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.CreateUpdatedWorkspaceImageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspaces.model.CreateUpdatedWorkspaceImageResponse =
      zio.aws.workspaces.model
        .CreateUpdatedWorkspaceImageResponse(imageId.map(value => value))
    def imageId: Option[WorkspaceImageId]
    def getImageId: ZIO[Any, AwsError, WorkspaceImageId] =
      AwsError.unwrapOptionField("imageId", imageId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.CreateUpdatedWorkspaceImageResponse
  ) extends zio.aws.workspaces.model.CreateUpdatedWorkspaceImageResponse.ReadOnly {
    override val imageId: Option[WorkspaceImageId] = scala
      .Option(impl.imageId())
      .map(value => zio.aws.workspaces.model.primitives.WorkspaceImageId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.CreateUpdatedWorkspaceImageResponse
  ): zio.aws.workspaces.model.CreateUpdatedWorkspaceImageResponse.ReadOnly =
    new Wrapper(impl)
}
