package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.IpGroupId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateIpGroupResponse(groupId: Option[IpGroupId] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.CreateIpGroupResponse = {
    import CreateIpGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.CreateIpGroupResponse
      .builder()
      .optionallyWith(
        groupId.map(value => IpGroupId.unwrap(value): java.lang.String)
      )(_.groupId)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.CreateIpGroupResponse.ReadOnly =
    zio.aws.workspaces.model.CreateIpGroupResponse.wrap(buildAwsValue())
}
object CreateIpGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.CreateIpGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.CreateIpGroupResponse =
      zio.aws.workspaces.model
        .CreateIpGroupResponse(groupId.map(value => value))
    def groupId: Option[IpGroupId]
    def getGroupId: ZIO[Any, AwsError, IpGroupId] =
      AwsError.unwrapOptionField("groupId", groupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.CreateIpGroupResponse
  ) extends zio.aws.workspaces.model.CreateIpGroupResponse.ReadOnly {
    override val groupId: Option[IpGroupId] = scala
      .Option(impl.groupId())
      .map(value => zio.aws.workspaces.model.primitives.IpGroupId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.CreateIpGroupResponse
  ): zio.aws.workspaces.model.CreateIpGroupResponse.ReadOnly = new Wrapper(impl)
}
