package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.ConnectionAliasId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateConnectionAliasResponse(
    aliasId: Option[ConnectionAliasId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.CreateConnectionAliasResponse = {
    import CreateConnectionAliasResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.CreateConnectionAliasResponse
      .builder()
      .optionallyWith(
        aliasId.map(value => ConnectionAliasId.unwrap(value): java.lang.String)
      )(_.aliasId)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.CreateConnectionAliasResponse.ReadOnly =
    zio.aws.workspaces.model.CreateConnectionAliasResponse.wrap(buildAwsValue())
}
object CreateConnectionAliasResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.CreateConnectionAliasResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.CreateConnectionAliasResponse =
      zio.aws.workspaces.model
        .CreateConnectionAliasResponse(aliasId.map(value => value))
    def aliasId: Option[ConnectionAliasId]
    def getAliasId: ZIO[Any, AwsError, ConnectionAliasId] =
      AwsError.unwrapOptionField("aliasId", aliasId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.CreateConnectionAliasResponse
  ) extends zio.aws.workspaces.model.CreateConnectionAliasResponse.ReadOnly {
    override val aliasId: Option[ConnectionAliasId] = scala
      .Option(impl.aliasId())
      .map(value =>
        zio.aws.workspaces.model.primitives.ConnectionAliasId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.CreateConnectionAliasResponse
  ): zio.aws.workspaces.model.CreateConnectionAliasResponse.ReadOnly =
    new Wrapper(impl)
}
