package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.AmazonUuid
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateConnectClientAddInResponse(
    addInId: Option[AmazonUuid] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.CreateConnectClientAddInResponse = {
    import CreateConnectClientAddInResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.CreateConnectClientAddInResponse
      .builder()
      .optionallyWith(
        addInId.map(value => AmazonUuid.unwrap(value): java.lang.String)
      )(_.addInId)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.CreateConnectClientAddInResponse.ReadOnly =
    zio.aws.workspaces.model.CreateConnectClientAddInResponse
      .wrap(buildAwsValue())
}
object CreateConnectClientAddInResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.CreateConnectClientAddInResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.CreateConnectClientAddInResponse =
      zio.aws.workspaces.model
        .CreateConnectClientAddInResponse(addInId.map(value => value))
    def addInId: Option[AmazonUuid]
    def getAddInId: ZIO[Any, AwsError, AmazonUuid] =
      AwsError.unwrapOptionField("addInId", addInId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.CreateConnectClientAddInResponse
  ) extends zio.aws.workspaces.model.CreateConnectClientAddInResponse.ReadOnly {
    override val addInId: Option[AmazonUuid] = scala
      .Option(impl.addInId())
      .map(value => zio.aws.workspaces.model.primitives.AmazonUuid(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.CreateConnectClientAddInResponse
  ): zio.aws.workspaces.model.CreateConnectClientAddInResponse.ReadOnly =
    new Wrapper(impl)
}
