package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{
  AddInUrl,
  AddInName,
  DirectoryId,
  AmazonUuid
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ConnectClientAddIn(
    addInId: Option[AmazonUuid] = None,
    resourceId: Option[DirectoryId] = None,
    name: Option[AddInName] = None,
    url: Option[AddInUrl] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.ConnectClientAddIn = {
    import ConnectClientAddIn.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.ConnectClientAddIn
      .builder()
      .optionallyWith(
        addInId.map(value => AmazonUuid.unwrap(value): java.lang.String)
      )(_.addInId)
      .optionallyWith(
        resourceId.map(value => DirectoryId.unwrap(value): java.lang.String)
      )(_.resourceId)
      .optionallyWith(
        name.map(value => AddInName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        url.map(value => AddInUrl.unwrap(value): java.lang.String)
      )(_.url)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.ConnectClientAddIn.ReadOnly =
    zio.aws.workspaces.model.ConnectClientAddIn.wrap(buildAwsValue())
}
object ConnectClientAddIn {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.ConnectClientAddIn
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.ConnectClientAddIn =
      zio.aws.workspaces.model.ConnectClientAddIn(
        addInId.map(value => value),
        resourceId.map(value => value),
        name.map(value => value),
        url.map(value => value)
      )
    def addInId: Option[AmazonUuid]
    def resourceId: Option[DirectoryId]
    def name: Option[AddInName]
    def url: Option[AddInUrl]
    def getAddInId: ZIO[Any, AwsError, AmazonUuid] =
      AwsError.unwrapOptionField("addInId", addInId)
    def getResourceId: ZIO[Any, AwsError, DirectoryId] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getName: ZIO[Any, AwsError, AddInName] =
      AwsError.unwrapOptionField("name", name)
    def getUrl: ZIO[Any, AwsError, AddInUrl] =
      AwsError.unwrapOptionField("url", url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.ConnectClientAddIn
  ) extends zio.aws.workspaces.model.ConnectClientAddIn.ReadOnly {
    override val addInId: Option[AmazonUuid] = scala
      .Option(impl.addInId())
      .map(value => zio.aws.workspaces.model.primitives.AmazonUuid(value))
    override val resourceId: Option[DirectoryId] = scala
      .Option(impl.resourceId())
      .map(value => zio.aws.workspaces.model.primitives.DirectoryId(value))
    override val name: Option[AddInName] = scala
      .Option(impl.name())
      .map(value => zio.aws.workspaces.model.primitives.AddInName(value))
    override val url: Option[AddInUrl] = scala
      .Option(impl.url())
      .map(value => zio.aws.workspaces.model.primitives.AddInUrl(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.ConnectClientAddIn
  ): zio.aws.workspaces.model.ConnectClientAddIn.ReadOnly = new Wrapper(impl)
}
