package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{
  AwsAccount,
  Timestamp,
  WorkspaceImageErrorCode,
  WorkspaceImageName,
  Description,
  WorkspaceImageId,
  WorkspaceImageDescription
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class WorkspaceImage(
    imageId: Option[WorkspaceImageId] = None,
    name: Option[WorkspaceImageName] = None,
    description: Option[WorkspaceImageDescription] = None,
    operatingSystem: Option[zio.aws.workspaces.model.OperatingSystem] = None,
    state: Option[zio.aws.workspaces.model.WorkspaceImageState] = None,
    requiredTenancy: Option[
      zio.aws.workspaces.model.WorkspaceImageRequiredTenancy
    ] = None,
    errorCode: Option[WorkspaceImageErrorCode] = None,
    errorMessage: Option[Description] = None,
    created: Option[Timestamp] = None,
    ownerAccountId: Option[AwsAccount] = None,
    updates: Option[zio.aws.workspaces.model.UpdateResult] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.WorkspaceImage = {
    import WorkspaceImage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.WorkspaceImage
      .builder()
      .optionallyWith(
        imageId.map(value => WorkspaceImageId.unwrap(value): java.lang.String)
      )(_.imageId)
      .optionallyWith(
        name.map(value => WorkspaceImageName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          WorkspaceImageDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(operatingSystem.map(value => value.buildAwsValue()))(
        _.operatingSystem
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(requiredTenancy.map(value => value.unwrap))(
        _.requiredTenancy
      )
      .optionallyWith(
        errorCode.map(value =>
          WorkspaceImageErrorCode.unwrap(value): java.lang.String
        )
      )(_.errorCode)
      .optionallyWith(
        errorMessage.map(value => Description.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .optionallyWith(created.map(value => Timestamp.unwrap(value): Instant))(
        _.created
      )
      .optionallyWith(
        ownerAccountId.map(value => AwsAccount.unwrap(value): java.lang.String)
      )(_.ownerAccountId)
      .optionallyWith(updates.map(value => value.buildAwsValue()))(_.updates)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.WorkspaceImage.ReadOnly =
    zio.aws.workspaces.model.WorkspaceImage.wrap(buildAwsValue())
}
object WorkspaceImage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.WorkspaceImage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.WorkspaceImage =
      zio.aws.workspaces.model.WorkspaceImage(
        imageId.map(value => value),
        name.map(value => value),
        description.map(value => value),
        operatingSystem.map(value => value.asEditable),
        state.map(value => value),
        requiredTenancy.map(value => value),
        errorCode.map(value => value),
        errorMessage.map(value => value),
        created.map(value => value),
        ownerAccountId.map(value => value),
        updates.map(value => value.asEditable)
      )
    def imageId: Option[WorkspaceImageId]
    def name: Option[WorkspaceImageName]
    def description: Option[WorkspaceImageDescription]
    def operatingSystem
        : Option[zio.aws.workspaces.model.OperatingSystem.ReadOnly]
    def state: Option[zio.aws.workspaces.model.WorkspaceImageState]
    def requiredTenancy
        : Option[zio.aws.workspaces.model.WorkspaceImageRequiredTenancy]
    def errorCode: Option[WorkspaceImageErrorCode]
    def errorMessage: Option[Description]
    def created: Option[Timestamp]
    def ownerAccountId: Option[AwsAccount]
    def updates: Option[zio.aws.workspaces.model.UpdateResult.ReadOnly]
    def getImageId: ZIO[Any, AwsError, WorkspaceImageId] =
      AwsError.unwrapOptionField("imageId", imageId)
    def getName: ZIO[Any, AwsError, WorkspaceImageName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, WorkspaceImageDescription] =
      AwsError.unwrapOptionField("description", description)
    def getOperatingSystem: ZIO[
      Any,
      AwsError,
      zio.aws.workspaces.model.OperatingSystem.ReadOnly
    ] = AwsError.unwrapOptionField("operatingSystem", operatingSystem)
    def getState
        : ZIO[Any, AwsError, zio.aws.workspaces.model.WorkspaceImageState] =
      AwsError.unwrapOptionField("state", state)
    def getRequiredTenancy: ZIO[
      Any,
      AwsError,
      zio.aws.workspaces.model.WorkspaceImageRequiredTenancy
    ] = AwsError.unwrapOptionField("requiredTenancy", requiredTenancy)
    def getErrorCode: ZIO[Any, AwsError, WorkspaceImageErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getCreated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("created", created)
    def getOwnerAccountId: ZIO[Any, AwsError, AwsAccount] =
      AwsError.unwrapOptionField("ownerAccountId", ownerAccountId)
    def getUpdates
        : ZIO[Any, AwsError, zio.aws.workspaces.model.UpdateResult.ReadOnly] =
      AwsError.unwrapOptionField("updates", updates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.WorkspaceImage
  ) extends zio.aws.workspaces.model.WorkspaceImage.ReadOnly {
    override val imageId: Option[WorkspaceImageId] = scala
      .Option(impl.imageId())
      .map(value => zio.aws.workspaces.model.primitives.WorkspaceImageId(value))
    override val name: Option[WorkspaceImageName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.workspaces.model.primitives.WorkspaceImageName(value)
      )
    override val description: Option[WorkspaceImageDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.workspaces.model.primitives.WorkspaceImageDescription(value)
      )
    override val operatingSystem
        : Option[zio.aws.workspaces.model.OperatingSystem.ReadOnly] = scala
      .Option(impl.operatingSystem())
      .map(value => zio.aws.workspaces.model.OperatingSystem.wrap(value))
    override val state: Option[zio.aws.workspaces.model.WorkspaceImageState] =
      scala
        .Option(impl.state())
        .map(value => zio.aws.workspaces.model.WorkspaceImageState.wrap(value))
    override val requiredTenancy
        : Option[zio.aws.workspaces.model.WorkspaceImageRequiredTenancy] = scala
      .Option(impl.requiredTenancy())
      .map(value =>
        zio.aws.workspaces.model.WorkspaceImageRequiredTenancy.wrap(value)
      )
    override val errorCode: Option[WorkspaceImageErrorCode] = scala
      .Option(impl.errorCode())
      .map(value =>
        zio.aws.workspaces.model.primitives.WorkspaceImageErrorCode(value)
      )
    override val errorMessage: Option[Description] = scala
      .Option(impl.errorMessage())
      .map(value => zio.aws.workspaces.model.primitives.Description(value))
    override val created: Option[Timestamp] = scala
      .Option(impl.created())
      .map(value => zio.aws.workspaces.model.primitives.Timestamp(value))
    override val ownerAccountId: Option[AwsAccount] = scala
      .Option(impl.ownerAccountId())
      .map(value => zio.aws.workspaces.model.primitives.AwsAccount(value))
    override val updates
        : Option[zio.aws.workspaces.model.UpdateResult.ReadOnly] = scala
      .Option(impl.updates())
      .map(value => zio.aws.workspaces.model.UpdateResult.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.WorkspaceImage
  ): zio.aws.workspaces.model.WorkspaceImage.ReadOnly = new Wrapper(impl)
}
