package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{
  SubnetId,
  SecurityGroupId,
  DirectoryName,
  RegistrationCode,
  IpGroupId,
  IpAddress,
  UserName,
  DirectoryId,
  Alias,
  ARN
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class WorkspaceDirectory(
    directoryId: Option[DirectoryId] = None,
    alias: Option[Alias] = None,
    directoryName: Option[DirectoryName] = None,
    registrationCode: Option[RegistrationCode] = None,
    subnetIds: Option[Iterable[SubnetId]] = None,
    dnsIpAddresses: Option[Iterable[IpAddress]] = None,
    customerUserName: Option[UserName] = None,
    iamRoleId: Option[ARN] = None,
    directoryType: Option[zio.aws.workspaces.model.WorkspaceDirectoryType] =
      None,
    workspaceSecurityGroupId: Option[SecurityGroupId] = None,
    state: Option[zio.aws.workspaces.model.WorkspaceDirectoryState] = None,
    workspaceCreationProperties: Option[
      zio.aws.workspaces.model.DefaultWorkspaceCreationProperties
    ] = None,
    ipGroupIds: Option[Iterable[IpGroupId]] = None,
    workspaceAccessProperties: Option[
      zio.aws.workspaces.model.WorkspaceAccessProperties
    ] = None,
    tenancy: Option[zio.aws.workspaces.model.Tenancy] = None,
    selfservicePermissions: Option[
      zio.aws.workspaces.model.SelfservicePermissions
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.WorkspaceDirectory = {
    import WorkspaceDirectory.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.WorkspaceDirectory
      .builder()
      .optionallyWith(
        directoryId.map(value => DirectoryId.unwrap(value): java.lang.String)
      )(_.directoryId)
      .optionallyWith(
        alias.map(value => Alias.unwrap(value): java.lang.String)
      )(_.alias)
      .optionallyWith(
        directoryName.map(value =>
          DirectoryName.unwrap(value): java.lang.String
        )
      )(_.directoryName)
      .optionallyWith(
        registrationCode.map(value =>
          RegistrationCode.unwrap(value): java.lang.String
        )
      )(_.registrationCode)
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(
        dnsIpAddresses.map(value =>
          value.map { item =>
            IpAddress.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.dnsIpAddresses)
      .optionallyWith(
        customerUserName.map(value => UserName.unwrap(value): java.lang.String)
      )(_.customerUserName)
      .optionallyWith(
        iamRoleId.map(value => ARN.unwrap(value): java.lang.String)
      )(_.iamRoleId)
      .optionallyWith(directoryType.map(value => value.unwrap))(_.directoryType)
      .optionallyWith(
        workspaceSecurityGroupId.map(value =>
          SecurityGroupId.unwrap(value): java.lang.String
        )
      )(_.workspaceSecurityGroupId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        workspaceCreationProperties.map(value => value.buildAwsValue())
      )(_.workspaceCreationProperties)
      .optionallyWith(
        ipGroupIds.map(value =>
          value.map { item =>
            IpGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ipGroupIds)
      .optionallyWith(
        workspaceAccessProperties.map(value => value.buildAwsValue())
      )(_.workspaceAccessProperties)
      .optionallyWith(tenancy.map(value => value.unwrap))(_.tenancy)
      .optionallyWith(
        selfservicePermissions.map(value => value.buildAwsValue())
      )(_.selfservicePermissions)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.WorkspaceDirectory.ReadOnly =
    zio.aws.workspaces.model.WorkspaceDirectory.wrap(buildAwsValue())
}
object WorkspaceDirectory {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.WorkspaceDirectory
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.WorkspaceDirectory =
      zio.aws.workspaces.model.WorkspaceDirectory(
        directoryId.map(value => value),
        alias.map(value => value),
        directoryName.map(value => value),
        registrationCode.map(value => value),
        subnetIds.map(value => value),
        dnsIpAddresses.map(value => value),
        customerUserName.map(value => value),
        iamRoleId.map(value => value),
        directoryType.map(value => value),
        workspaceSecurityGroupId.map(value => value),
        state.map(value => value),
        workspaceCreationProperties.map(value => value.asEditable),
        ipGroupIds.map(value => value),
        workspaceAccessProperties.map(value => value.asEditable),
        tenancy.map(value => value),
        selfservicePermissions.map(value => value.asEditable)
      )
    def directoryId: Option[DirectoryId]
    def alias: Option[Alias]
    def directoryName: Option[DirectoryName]
    def registrationCode: Option[RegistrationCode]
    def subnetIds: Option[List[SubnetId]]
    def dnsIpAddresses: Option[List[IpAddress]]
    def customerUserName: Option[UserName]
    def iamRoleId: Option[ARN]
    def directoryType: Option[zio.aws.workspaces.model.WorkspaceDirectoryType]
    def workspaceSecurityGroupId: Option[SecurityGroupId]
    def state: Option[zio.aws.workspaces.model.WorkspaceDirectoryState]
    def workspaceCreationProperties: Option[
      zio.aws.workspaces.model.DefaultWorkspaceCreationProperties.ReadOnly
    ]
    def ipGroupIds: Option[List[IpGroupId]]
    def workspaceAccessProperties
        : Option[zio.aws.workspaces.model.WorkspaceAccessProperties.ReadOnly]
    def tenancy: Option[zio.aws.workspaces.model.Tenancy]
    def selfservicePermissions
        : Option[zio.aws.workspaces.model.SelfservicePermissions.ReadOnly]
    def getDirectoryId: ZIO[Any, AwsError, DirectoryId] =
      AwsError.unwrapOptionField("directoryId", directoryId)
    def getAlias: ZIO[Any, AwsError, Alias] =
      AwsError.unwrapOptionField("alias", alias)
    def getDirectoryName: ZIO[Any, AwsError, DirectoryName] =
      AwsError.unwrapOptionField("directoryName", directoryName)
    def getRegistrationCode: ZIO[Any, AwsError, RegistrationCode] =
      AwsError.unwrapOptionField("registrationCode", registrationCode)
    def getSubnetIds: ZIO[Any, AwsError, List[SubnetId]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getDnsIpAddresses: ZIO[Any, AwsError, List[IpAddress]] =
      AwsError.unwrapOptionField("dnsIpAddresses", dnsIpAddresses)
    def getCustomerUserName: ZIO[Any, AwsError, UserName] =
      AwsError.unwrapOptionField("customerUserName", customerUserName)
    def getIamRoleId: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("iamRoleId", iamRoleId)
    def getDirectoryType
        : ZIO[Any, AwsError, zio.aws.workspaces.model.WorkspaceDirectoryType] =
      AwsError.unwrapOptionField("directoryType", directoryType)
    def getWorkspaceSecurityGroupId: ZIO[Any, AwsError, SecurityGroupId] =
      AwsError.unwrapOptionField(
        "workspaceSecurityGroupId",
        workspaceSecurityGroupId
      )
    def getState
        : ZIO[Any, AwsError, zio.aws.workspaces.model.WorkspaceDirectoryState] =
      AwsError.unwrapOptionField("state", state)
    def getWorkspaceCreationProperties: ZIO[
      Any,
      AwsError,
      zio.aws.workspaces.model.DefaultWorkspaceCreationProperties.ReadOnly
    ] = AwsError.unwrapOptionField(
      "workspaceCreationProperties",
      workspaceCreationProperties
    )
    def getIpGroupIds: ZIO[Any, AwsError, List[IpGroupId]] =
      AwsError.unwrapOptionField("ipGroupIds", ipGroupIds)
    def getWorkspaceAccessProperties: ZIO[
      Any,
      AwsError,
      zio.aws.workspaces.model.WorkspaceAccessProperties.ReadOnly
    ] = AwsError.unwrapOptionField(
      "workspaceAccessProperties",
      workspaceAccessProperties
    )
    def getTenancy: ZIO[Any, AwsError, zio.aws.workspaces.model.Tenancy] =
      AwsError.unwrapOptionField("tenancy", tenancy)
    def getSelfservicePermissions: ZIO[
      Any,
      AwsError,
      zio.aws.workspaces.model.SelfservicePermissions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "selfservicePermissions",
      selfservicePermissions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.WorkspaceDirectory
  ) extends zio.aws.workspaces.model.WorkspaceDirectory.ReadOnly {
    override val directoryId: Option[DirectoryId] = scala
      .Option(impl.directoryId())
      .map(value => zio.aws.workspaces.model.primitives.DirectoryId(value))
    override val alias: Option[Alias] = scala
      .Option(impl.alias())
      .map(value => zio.aws.workspaces.model.primitives.Alias(value))
    override val directoryName: Option[DirectoryName] = scala
      .Option(impl.directoryName())
      .map(value => zio.aws.workspaces.model.primitives.DirectoryName(value))
    override val registrationCode: Option[RegistrationCode] = scala
      .Option(impl.registrationCode())
      .map(value => zio.aws.workspaces.model.primitives.RegistrationCode(value))
    override val subnetIds: Option[List[SubnetId]] = scala
      .Option(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workspaces.model.primitives.SubnetId(item)
        }.toList
      )
    override val dnsIpAddresses: Option[List[IpAddress]] = scala
      .Option(impl.dnsIpAddresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workspaces.model.primitives.IpAddress(item)
        }.toList
      )
    override val customerUserName: Option[UserName] = scala
      .Option(impl.customerUserName())
      .map(value => zio.aws.workspaces.model.primitives.UserName(value))
    override val iamRoleId: Option[ARN] = scala
      .Option(impl.iamRoleId())
      .map(value => zio.aws.workspaces.model.primitives.ARN(value))
    override val directoryType
        : Option[zio.aws.workspaces.model.WorkspaceDirectoryType] = scala
      .Option(impl.directoryType())
      .map(value => zio.aws.workspaces.model.WorkspaceDirectoryType.wrap(value))
    override val workspaceSecurityGroupId: Option[SecurityGroupId] = scala
      .Option(impl.workspaceSecurityGroupId())
      .map(value => zio.aws.workspaces.model.primitives.SecurityGroupId(value))
    override val state
        : Option[zio.aws.workspaces.model.WorkspaceDirectoryState] = scala
      .Option(impl.state())
      .map(value =>
        zio.aws.workspaces.model.WorkspaceDirectoryState.wrap(value)
      )
    override val workspaceCreationProperties: Option[
      zio.aws.workspaces.model.DefaultWorkspaceCreationProperties.ReadOnly
    ] = scala
      .Option(impl.workspaceCreationProperties())
      .map(value =>
        zio.aws.workspaces.model.DefaultWorkspaceCreationProperties.wrap(value)
      )
    override val ipGroupIds: Option[List[IpGroupId]] = scala
      .Option(impl.ipGroupIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workspaces.model.primitives.IpGroupId(item)
        }.toList
      )
    override val workspaceAccessProperties
        : Option[zio.aws.workspaces.model.WorkspaceAccessProperties.ReadOnly] =
      scala
        .Option(impl.workspaceAccessProperties())
        .map(value =>
          zio.aws.workspaces.model.WorkspaceAccessProperties.wrap(value)
        )
    override val tenancy: Option[zio.aws.workspaces.model.Tenancy] = scala
      .Option(impl.tenancy())
      .map(value => zio.aws.workspaces.model.Tenancy.wrap(value))
    override val selfservicePermissions
        : Option[zio.aws.workspaces.model.SelfservicePermissions.ReadOnly] =
      scala
        .Option(impl.selfservicePermissions())
        .map(value =>
          zio.aws.workspaces.model.SelfservicePermissions.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.WorkspaceDirectory
  ): zio.aws.workspaces.model.WorkspaceDirectory.ReadOnly = new Wrapper(impl)
}
