package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{
  AwsAccount,
  BooleanObject,
  WorkspaceImageId
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateWorkspaceImagePermissionRequest(
    imageId: WorkspaceImageId,
    allowCopyImage: BooleanObject,
    sharedAccountId: AwsAccount
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.UpdateWorkspaceImagePermissionRequest = {
    import UpdateWorkspaceImagePermissionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.UpdateWorkspaceImagePermissionRequest
      .builder()
      .imageId(WorkspaceImageId.unwrap(imageId): java.lang.String)
      .allowCopyImage(BooleanObject.unwrap(allowCopyImage): java.lang.Boolean)
      .sharedAccountId(AwsAccount.unwrap(sharedAccountId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.UpdateWorkspaceImagePermissionRequest.ReadOnly =
    zio.aws.workspaces.model.UpdateWorkspaceImagePermissionRequest
      .wrap(buildAwsValue())
}
object UpdateWorkspaceImagePermissionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.UpdateWorkspaceImagePermissionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspaces.model.UpdateWorkspaceImagePermissionRequest =
      zio.aws.workspaces.model.UpdateWorkspaceImagePermissionRequest(
        imageId,
        allowCopyImage,
        sharedAccountId
      )
    def imageId: WorkspaceImageId
    def allowCopyImage: BooleanObject
    def sharedAccountId: AwsAccount
    def getImageId: ZIO[Any, Nothing, WorkspaceImageId] = ZIO.succeed(imageId)
    def getAllowCopyImage: ZIO[Any, Nothing, BooleanObject] =
      ZIO.succeed(allowCopyImage)
    def getSharedAccountId: ZIO[Any, Nothing, AwsAccount] =
      ZIO.succeed(sharedAccountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.UpdateWorkspaceImagePermissionRequest
  ) extends zio.aws.workspaces.model.UpdateWorkspaceImagePermissionRequest.ReadOnly {
    override val imageId: WorkspaceImageId =
      zio.aws.workspaces.model.primitives.WorkspaceImageId(impl.imageId())
    override val allowCopyImage: BooleanObject =
      zio.aws.workspaces.model.primitives.BooleanObject(impl.allowCopyImage())
    override val sharedAccountId: AwsAccount =
      zio.aws.workspaces.model.primitives.AwsAccount(impl.sharedAccountId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.UpdateWorkspaceImagePermissionRequest
  ): zio.aws.workspaces.model.UpdateWorkspaceImagePermissionRequest.ReadOnly =
    new Wrapper(impl)
}
