package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RootStorage(capacity: Option[NonEmptyString] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.RootStorage = {
    import RootStorage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.RootStorage
      .builder()
      .optionallyWith(
        capacity.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.capacity)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.RootStorage.ReadOnly =
    zio.aws.workspaces.model.RootStorage.wrap(buildAwsValue())
}
object RootStorage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.RootStorage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.RootStorage =
      zio.aws.workspaces.model.RootStorage(capacity.map(value => value))
    def capacity: Option[NonEmptyString]
    def getCapacity: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("capacity", capacity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.RootStorage
  ) extends zio.aws.workspaces.model.RootStorage.ReadOnly {
    override val capacity: Option[NonEmptyString] = scala
      .Option(impl.capacity())
      .map(value => zio.aws.workspaces.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.RootStorage
  ): zio.aws.workspaces.model.RootStorage.ReadOnly = new Wrapper(impl)
}
