package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{
  BooleanObject,
  SubnetId,
  DirectoryId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RegisterWorkspaceDirectoryRequest(
    directoryId: DirectoryId,
    subnetIds: Option[Iterable[SubnetId]] = None,
    enableWorkDocs: BooleanObject,
    enableSelfService: Option[BooleanObject] = None,
    tenancy: Option[zio.aws.workspaces.model.Tenancy] = None,
    tags: Option[Iterable[zio.aws.workspaces.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.RegisterWorkspaceDirectoryRequest = {
    import RegisterWorkspaceDirectoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.RegisterWorkspaceDirectoryRequest
      .builder()
      .directoryId(DirectoryId.unwrap(directoryId): java.lang.String)
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .enableWorkDocs(BooleanObject.unwrap(enableWorkDocs): java.lang.Boolean)
      .optionallyWith(
        enableSelfService.map(value =>
          BooleanObject.unwrap(value): java.lang.Boolean
        )
      )(_.enableSelfService)
      .optionallyWith(tenancy.map(value => value.unwrap))(_.tenancy)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.RegisterWorkspaceDirectoryRequest.ReadOnly =
    zio.aws.workspaces.model.RegisterWorkspaceDirectoryRequest
      .wrap(buildAwsValue())
}
object RegisterWorkspaceDirectoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.RegisterWorkspaceDirectoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.RegisterWorkspaceDirectoryRequest =
      zio.aws.workspaces.model.RegisterWorkspaceDirectoryRequest(
        directoryId,
        subnetIds.map(value => value),
        enableWorkDocs,
        enableSelfService.map(value => value),
        tenancy.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def directoryId: DirectoryId
    def subnetIds: Option[List[SubnetId]]
    def enableWorkDocs: BooleanObject
    def enableSelfService: Option[BooleanObject]
    def tenancy: Option[zio.aws.workspaces.model.Tenancy]
    def tags: Option[List[zio.aws.workspaces.model.Tag.ReadOnly]]
    def getDirectoryId: ZIO[Any, Nothing, DirectoryId] =
      ZIO.succeed(directoryId)
    def getSubnetIds: ZIO[Any, AwsError, List[SubnetId]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getEnableWorkDocs: ZIO[Any, Nothing, BooleanObject] =
      ZIO.succeed(enableWorkDocs)
    def getEnableSelfService: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField("enableSelfService", enableSelfService)
    def getTenancy: ZIO[Any, AwsError, zio.aws.workspaces.model.Tenancy] =
      AwsError.unwrapOptionField("tenancy", tenancy)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.workspaces.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.RegisterWorkspaceDirectoryRequest
  ) extends zio.aws.workspaces.model.RegisterWorkspaceDirectoryRequest.ReadOnly {
    override val directoryId: DirectoryId =
      zio.aws.workspaces.model.primitives.DirectoryId(impl.directoryId())
    override val subnetIds: Option[List[SubnetId]] = scala
      .Option(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workspaces.model.primitives.SubnetId(item)
        }.toList
      )
    override val enableWorkDocs: BooleanObject =
      zio.aws.workspaces.model.primitives.BooleanObject(impl.enableWorkDocs())
    override val enableSelfService: Option[BooleanObject] = scala
      .Option(impl.enableSelfService())
      .map(value => zio.aws.workspaces.model.primitives.BooleanObject(value))
    override val tenancy: Option[zio.aws.workspaces.model.Tenancy] = scala
      .Option(impl.tenancy())
      .map(value => zio.aws.workspaces.model.Tenancy.wrap(value))
    override val tags: Option[List[zio.aws.workspaces.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspaces.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.RegisterWorkspaceDirectoryRequest
  ): zio.aws.workspaces.model.RegisterWorkspaceDirectoryRequest.ReadOnly =
    new Wrapper(impl)
}
