package zio.aws.workspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RebootWorkspacesResponse(
    failedRequests: Option[
      Iterable[zio.aws.workspaces.model.FailedWorkspaceChangeRequest]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.RebootWorkspacesResponse = {
    import RebootWorkspacesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.RebootWorkspacesResponse
      .builder()
      .optionallyWith(
        failedRequests.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failedRequests)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.RebootWorkspacesResponse.ReadOnly =
    zio.aws.workspaces.model.RebootWorkspacesResponse.wrap(buildAwsValue())
}
object RebootWorkspacesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.RebootWorkspacesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.RebootWorkspacesResponse =
      zio.aws.workspaces.model.RebootWorkspacesResponse(
        failedRequests.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def failedRequests: Option[
      List[zio.aws.workspaces.model.FailedWorkspaceChangeRequest.ReadOnly]
    ]
    def getFailedRequests: ZIO[Any, AwsError, List[
      zio.aws.workspaces.model.FailedWorkspaceChangeRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("failedRequests", failedRequests)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.RebootWorkspacesResponse
  ) extends zio.aws.workspaces.model.RebootWorkspacesResponse.ReadOnly {
    override val failedRequests: Option[
      List[zio.aws.workspaces.model.FailedWorkspaceChangeRequest.ReadOnly]
    ] = scala
      .Option(impl.failedRequests())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workspaces.model.FailedWorkspaceChangeRequest.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.RebootWorkspacesResponse
  ): zio.aws.workspaces.model.RebootWorkspacesResponse.ReadOnly = new Wrapper(
    impl
  )
}
