package zio.aws.workspaces.model
import scala.jdk.CollectionConverters.*
sealed trait ModificationResourceEnum {
  def unwrap: software.amazon.awssdk.services.workspaces.model.ModificationResourceEnum
}
object ModificationResourceEnum {
  def wrap(
      value: software.amazon.awssdk.services.workspaces.model.ModificationResourceEnum
  ): zio.aws.workspaces.model.ModificationResourceEnum = value match {
    case software.amazon.awssdk.services.workspaces.model.ModificationResourceEnum.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workspaces.model.ModificationResourceEnum.ROOT_VOLUME =>
      val r = ROOT_VOLUME
      r
    case software.amazon.awssdk.services.workspaces.model.ModificationResourceEnum.USER_VOLUME =>
      val r = USER_VOLUME
      r
    case software.amazon.awssdk.services.workspaces.model.ModificationResourceEnum.COMPUTE_TYPE =>
      val r = COMPUTE_TYPE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.workspaces.model.ModificationResourceEnum {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.ModificationResourceEnum =
      software.amazon.awssdk.services.workspaces.model.ModificationResourceEnum.UNKNOWN_TO_SDK_VERSION
  }
  case object ROOT_VOLUME
      extends zio.aws.workspaces.model.ModificationResourceEnum {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.ModificationResourceEnum =
      software.amazon.awssdk.services.workspaces.model.ModificationResourceEnum.ROOT_VOLUME
  }
  case object USER_VOLUME
      extends zio.aws.workspaces.model.ModificationResourceEnum {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.ModificationResourceEnum =
      software.amazon.awssdk.services.workspaces.model.ModificationResourceEnum.USER_VOLUME
  }
  case object COMPUTE_TYPE
      extends zio.aws.workspaces.model.ModificationResourceEnum {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.ModificationResourceEnum =
      software.amazon.awssdk.services.workspaces.model.ModificationResourceEnum.COMPUTE_TYPE
  }
}
