package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeWorkspacesResponse(
    workspaces: Option[Iterable[zio.aws.workspaces.model.Workspace]] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesResponse = {
    import DescribeWorkspacesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesResponse
      .builder()
      .optionallyWith(
        workspaces.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.workspaces)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.DescribeWorkspacesResponse.ReadOnly =
    zio.aws.workspaces.model.DescribeWorkspacesResponse.wrap(buildAwsValue())
}
object DescribeWorkspacesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.DescribeWorkspacesResponse =
      zio.aws.workspaces.model.DescribeWorkspacesResponse(
        workspaces.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def workspaces: Option[List[zio.aws.workspaces.model.Workspace.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getWorkspaces: ZIO[Any, AwsError, List[
      zio.aws.workspaces.model.Workspace.ReadOnly
    ]] = AwsError.unwrapOptionField("workspaces", workspaces)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesResponse
  ) extends zio.aws.workspaces.model.DescribeWorkspacesResponse.ReadOnly {
    override val workspaces
        : Option[List[zio.aws.workspaces.model.Workspace.ReadOnly]] = scala
      .Option(impl.workspaces())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workspaces.model.Workspace.wrap(item)
        }.toList
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.workspaces.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesResponse
  ): zio.aws.workspaces.model.DescribeWorkspacesResponse.ReadOnly = new Wrapper(
    impl
  )
}
