package zio.aws.workspaces.model
import java.lang.Integer
import zio.aws.workspaces.model.primitives.{
  WorkspaceId,
  PaginationToken,
  Limit,
  BundleId,
  UserName,
  DirectoryId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeWorkspacesRequest(
    workspaceIds: Option[Iterable[WorkspaceId]] = None,
    directoryId: Option[DirectoryId] = None,
    userName: Option[UserName] = None,
    bundleId: Option[BundleId] = None,
    limit: Option[Limit] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesRequest = {
    import DescribeWorkspacesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesRequest
      .builder()
      .optionallyWith(
        workspaceIds.map(value =>
          value.map { item =>
            WorkspaceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.workspaceIds)
      .optionallyWith(
        directoryId.map(value => DirectoryId.unwrap(value): java.lang.String)
      )(_.directoryId)
      .optionallyWith(
        userName.map(value => UserName.unwrap(value): java.lang.String)
      )(_.userName)
      .optionallyWith(
        bundleId.map(value => BundleId.unwrap(value): java.lang.String)
      )(_.bundleId)
      .optionallyWith(limit.map(value => Limit.unwrap(value): Integer))(_.limit)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.DescribeWorkspacesRequest.ReadOnly =
    zio.aws.workspaces.model.DescribeWorkspacesRequest.wrap(buildAwsValue())
}
object DescribeWorkspacesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.DescribeWorkspacesRequest =
      zio.aws.workspaces.model.DescribeWorkspacesRequest(
        workspaceIds.map(value => value),
        directoryId.map(value => value),
        userName.map(value => value),
        bundleId.map(value => value),
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def workspaceIds: Option[List[WorkspaceId]]
    def directoryId: Option[DirectoryId]
    def userName: Option[UserName]
    def bundleId: Option[BundleId]
    def limit: Option[Limit]
    def nextToken: Option[PaginationToken]
    def getWorkspaceIds: ZIO[Any, AwsError, List[WorkspaceId]] =
      AwsError.unwrapOptionField("workspaceIds", workspaceIds)
    def getDirectoryId: ZIO[Any, AwsError, DirectoryId] =
      AwsError.unwrapOptionField("directoryId", directoryId)
    def getUserName: ZIO[Any, AwsError, UserName] =
      AwsError.unwrapOptionField("userName", userName)
    def getBundleId: ZIO[Any, AwsError, BundleId] =
      AwsError.unwrapOptionField("bundleId", bundleId)
    def getLimit: ZIO[Any, AwsError, Limit] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesRequest
  ) extends zio.aws.workspaces.model.DescribeWorkspacesRequest.ReadOnly {
    override val workspaceIds: Option[List[WorkspaceId]] = scala
      .Option(impl.workspaceIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workspaces.model.primitives.WorkspaceId(item)
        }.toList
      )
    override val directoryId: Option[DirectoryId] = scala
      .Option(impl.directoryId())
      .map(value => zio.aws.workspaces.model.primitives.DirectoryId(value))
    override val userName: Option[UserName] = scala
      .Option(impl.userName())
      .map(value => zio.aws.workspaces.model.primitives.UserName(value))
    override val bundleId: Option[BundleId] = scala
      .Option(impl.bundleId())
      .map(value => zio.aws.workspaces.model.primitives.BundleId(value))
    override val limit: Option[Limit] = scala
      .Option(impl.limit())
      .map(value => zio.aws.workspaces.model.primitives.Limit(value))
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.workspaces.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesRequest
  ): zio.aws.workspaces.model.DescribeWorkspacesRequest.ReadOnly = new Wrapper(
    impl
  )
}
