package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeWorkspaceImagesResponse(
    images: Option[Iterable[zio.aws.workspaces.model.WorkspaceImage]] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagesResponse = {
    import DescribeWorkspaceImagesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagesResponse
      .builder()
      .optionallyWith(
        images.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.images)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.DescribeWorkspaceImagesResponse.ReadOnly =
    zio.aws.workspaces.model.DescribeWorkspaceImagesResponse
      .wrap(buildAwsValue())
}
object DescribeWorkspaceImagesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.DescribeWorkspaceImagesResponse =
      zio.aws.workspaces.model.DescribeWorkspaceImagesResponse(
        images.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def images: Option[List[zio.aws.workspaces.model.WorkspaceImage.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getImages: ZIO[Any, AwsError, List[
      zio.aws.workspaces.model.WorkspaceImage.ReadOnly
    ]] = AwsError.unwrapOptionField("images", images)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagesResponse
  ) extends zio.aws.workspaces.model.DescribeWorkspaceImagesResponse.ReadOnly {
    override val images
        : Option[List[zio.aws.workspaces.model.WorkspaceImage.ReadOnly]] = scala
      .Option(impl.images())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workspaces.model.WorkspaceImage.wrap(item)
        }.toList
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.workspaces.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagesResponse
  ): zio.aws.workspaces.model.DescribeWorkspaceImagesResponse.ReadOnly =
    new Wrapper(impl)
}
