package zio.aws.workspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeTagsResponse(
    tagList: Option[Iterable[zio.aws.workspaces.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DescribeTagsResponse = {
    import DescribeTagsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DescribeTagsResponse
      .builder()
      .optionallyWith(
        tagList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagList)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.DescribeTagsResponse.ReadOnly =
    zio.aws.workspaces.model.DescribeTagsResponse.wrap(buildAwsValue())
}
object DescribeTagsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DescribeTagsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.DescribeTagsResponse =
      zio.aws.workspaces.model.DescribeTagsResponse(
        tagList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def tagList: Option[List[zio.aws.workspaces.model.Tag.ReadOnly]]
    def getTagList
        : ZIO[Any, AwsError, List[zio.aws.workspaces.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tagList", tagList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeTagsResponse
  ) extends zio.aws.workspaces.model.DescribeTagsResponse.ReadOnly {
    override val tagList: Option[List[zio.aws.workspaces.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tagList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspaces.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeTagsResponse
  ): zio.aws.workspaces.model.DescribeTagsResponse.ReadOnly = new Wrapper(impl)
}
