package zio.aws.workspaces.model
import java.lang.Integer
import zio.aws.workspaces.model.primitives.{
  PaginationToken,
  Limit,
  NonEmptyString,
  ConnectionAliasId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeConnectionAliasesRequest(
    aliasIds: Option[Iterable[ConnectionAliasId]] = None,
    resourceId: Option[NonEmptyString] = None,
    limit: Option[Limit] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasesRequest = {
    import DescribeConnectionAliasesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasesRequest
      .builder()
      .optionallyWith(
        aliasIds.map(value =>
          value.map { item =>
            ConnectionAliasId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.aliasIds)
      .optionallyWith(
        resourceId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.resourceId)
      .optionallyWith(limit.map(value => Limit.unwrap(value): Integer))(_.limit)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.DescribeConnectionAliasesRequest.ReadOnly =
    zio.aws.workspaces.model.DescribeConnectionAliasesRequest
      .wrap(buildAwsValue())
}
object DescribeConnectionAliasesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.DescribeConnectionAliasesRequest =
      zio.aws.workspaces.model.DescribeConnectionAliasesRequest(
        aliasIds.map(value => value),
        resourceId.map(value => value),
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def aliasIds: Option[List[ConnectionAliasId]]
    def resourceId: Option[NonEmptyString]
    def limit: Option[Limit]
    def nextToken: Option[PaginationToken]
    def getAliasIds: ZIO[Any, AwsError, List[ConnectionAliasId]] =
      AwsError.unwrapOptionField("aliasIds", aliasIds)
    def getResourceId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getLimit: ZIO[Any, AwsError, Limit] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasesRequest
  ) extends zio.aws.workspaces.model.DescribeConnectionAliasesRequest.ReadOnly {
    override val aliasIds: Option[List[ConnectionAliasId]] = scala
      .Option(impl.aliasIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workspaces.model.primitives.ConnectionAliasId(item)
        }.toList
      )
    override val resourceId: Option[NonEmptyString] = scala
      .Option(impl.resourceId())
      .map(value => zio.aws.workspaces.model.primitives.NonEmptyString(value))
    override val limit: Option[Limit] = scala
      .Option(impl.limit())
      .map(value => zio.aws.workspaces.model.primitives.Limit(value))
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.workspaces.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasesRequest
  ): zio.aws.workspaces.model.DescribeConnectionAliasesRequest.ReadOnly =
    new Wrapper(impl)
}
