package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{PaginationToken, ConnectionAliasId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeConnectionAliasPermissionsResponse(
    aliasId: Option[ConnectionAliasId] = None,
    connectionAliasPermissions: Option[
      Iterable[zio.aws.workspaces.model.ConnectionAliasPermission]
    ] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasPermissionsResponse = {
    import DescribeConnectionAliasPermissionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasPermissionsResponse
      .builder()
      .optionallyWith(
        aliasId.map(value => ConnectionAliasId.unwrap(value): java.lang.String)
      )(_.aliasId)
      .optionallyWith(
        connectionAliasPermissions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.connectionAliasPermissions)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.DescribeConnectionAliasPermissionsResponse.ReadOnly =
    zio.aws.workspaces.model.DescribeConnectionAliasPermissionsResponse
      .wrap(buildAwsValue())
}
object DescribeConnectionAliasPermissionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasPermissionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspaces.model.DescribeConnectionAliasPermissionsResponse =
      zio.aws.workspaces.model.DescribeConnectionAliasPermissionsResponse(
        aliasId.map(value => value),
        connectionAliasPermissions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def aliasId: Option[ConnectionAliasId]
    def connectionAliasPermissions: Option[
      List[zio.aws.workspaces.model.ConnectionAliasPermission.ReadOnly]
    ]
    def nextToken: Option[PaginationToken]
    def getAliasId: ZIO[Any, AwsError, ConnectionAliasId] =
      AwsError.unwrapOptionField("aliasId", aliasId)
    def getConnectionAliasPermissions: ZIO[Any, AwsError, List[
      zio.aws.workspaces.model.ConnectionAliasPermission.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "connectionAliasPermissions",
      connectionAliasPermissions
    )
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasPermissionsResponse
  ) extends zio.aws.workspaces.model.DescribeConnectionAliasPermissionsResponse.ReadOnly {
    override val aliasId: Option[ConnectionAliasId] = scala
      .Option(impl.aliasId())
      .map(value =>
        zio.aws.workspaces.model.primitives.ConnectionAliasId(value)
      )
    override val connectionAliasPermissions: Option[
      List[zio.aws.workspaces.model.ConnectionAliasPermission.ReadOnly]
    ] = scala
      .Option(impl.connectionAliasPermissions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workspaces.model.ConnectionAliasPermission.wrap(item)
        }.toList
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.workspaces.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasPermissionsResponse
  ): zio.aws.workspaces.model.DescribeConnectionAliasPermissionsResponse.ReadOnly =
    new Wrapper(impl)
}
