package zio.aws.workspaces.model
import java.lang.Integer
import zio.aws.workspaces.model.primitives.{
  Limit,
  PaginationToken,
  ConnectionAliasId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeConnectionAliasPermissionsRequest(
    aliasId: ConnectionAliasId,
    nextToken: Option[PaginationToken] = None,
    maxResults: Option[Limit] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasPermissionsRequest = {
    import DescribeConnectionAliasPermissionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasPermissionsRequest
      .builder()
      .aliasId(ConnectionAliasId.unwrap(aliasId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(maxResults.map(value => Limit.unwrap(value): Integer))(
        _.maxResults
      )
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.DescribeConnectionAliasPermissionsRequest.ReadOnly =
    zio.aws.workspaces.model.DescribeConnectionAliasPermissionsRequest
      .wrap(buildAwsValue())
}
object DescribeConnectionAliasPermissionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasPermissionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspaces.model.DescribeConnectionAliasPermissionsRequest =
      zio.aws.workspaces.model.DescribeConnectionAliasPermissionsRequest(
        aliasId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def aliasId: ConnectionAliasId
    def nextToken: Option[PaginationToken]
    def maxResults: Option[Limit]
    def getAliasId: ZIO[Any, Nothing, ConnectionAliasId] = ZIO.succeed(aliasId)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, Limit] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasPermissionsRequest
  ) extends zio.aws.workspaces.model.DescribeConnectionAliasPermissionsRequest.ReadOnly {
    override val aliasId: ConnectionAliasId =
      zio.aws.workspaces.model.primitives.ConnectionAliasId(impl.aliasId())
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.workspaces.model.primitives.PaginationToken(value))
    override val maxResults: Option[Limit] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.workspaces.model.primitives.Limit(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasPermissionsRequest
  ): zio.aws.workspaces.model.DescribeConnectionAliasPermissionsRequest.ReadOnly =
    new Wrapper(impl)
}
