package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeConnectClientAddInsResponse(
    addIns: Option[Iterable[zio.aws.workspaces.model.ConnectClientAddIn]] =
      None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DescribeConnectClientAddInsResponse = {
    import DescribeConnectClientAddInsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DescribeConnectClientAddInsResponse
      .builder()
      .optionallyWith(
        addIns.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.addIns)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.DescribeConnectClientAddInsResponse.ReadOnly =
    zio.aws.workspaces.model.DescribeConnectClientAddInsResponse
      .wrap(buildAwsValue())
}
object DescribeConnectClientAddInsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DescribeConnectClientAddInsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspaces.model.DescribeConnectClientAddInsResponse =
      zio.aws.workspaces.model.DescribeConnectClientAddInsResponse(
        addIns.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def addIns
        : Option[List[zio.aws.workspaces.model.ConnectClientAddIn.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getAddIns: ZIO[Any, AwsError, List[
      zio.aws.workspaces.model.ConnectClientAddIn.ReadOnly
    ]] = AwsError.unwrapOptionField("addIns", addIns)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeConnectClientAddInsResponse
  ) extends zio.aws.workspaces.model.DescribeConnectClientAddInsResponse.ReadOnly {
    override val addIns
        : Option[List[zio.aws.workspaces.model.ConnectClientAddIn.ReadOnly]] =
      scala
        .Option(impl.addIns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspaces.model.ConnectClientAddIn.wrap(item)
          }.toList
        )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.workspaces.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeConnectClientAddInsResponse
  ): zio.aws.workspaces.model.DescribeConnectClientAddInsResponse.ReadOnly =
    new Wrapper(impl)
}
