package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{
  SecurityGroupId,
  DefaultOu,
  BooleanObject
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DefaultWorkspaceCreationProperties(
    enableWorkDocs: Option[BooleanObject] = None,
    enableInternetAccess: Option[BooleanObject] = None,
    defaultOu: Option[DefaultOu] = None,
    customSecurityGroupId: Option[SecurityGroupId] = None,
    userEnabledAsLocalAdministrator: Option[BooleanObject] = None,
    enableMaintenanceMode: Option[BooleanObject] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DefaultWorkspaceCreationProperties = {
    import DefaultWorkspaceCreationProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DefaultWorkspaceCreationProperties
      .builder()
      .optionallyWith(
        enableWorkDocs.map(value =>
          BooleanObject.unwrap(value): java.lang.Boolean
        )
      )(_.enableWorkDocs)
      .optionallyWith(
        enableInternetAccess.map(value =>
          BooleanObject.unwrap(value): java.lang.Boolean
        )
      )(_.enableInternetAccess)
      .optionallyWith(
        defaultOu.map(value => DefaultOu.unwrap(value): java.lang.String)
      )(_.defaultOu)
      .optionallyWith(
        customSecurityGroupId.map(value =>
          SecurityGroupId.unwrap(value): java.lang.String
        )
      )(_.customSecurityGroupId)
      .optionallyWith(
        userEnabledAsLocalAdministrator.map(value =>
          BooleanObject.unwrap(value): java.lang.Boolean
        )
      )(_.userEnabledAsLocalAdministrator)
      .optionallyWith(
        enableMaintenanceMode.map(value =>
          BooleanObject.unwrap(value): java.lang.Boolean
        )
      )(_.enableMaintenanceMode)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.DefaultWorkspaceCreationProperties.ReadOnly =
    zio.aws.workspaces.model.DefaultWorkspaceCreationProperties
      .wrap(buildAwsValue())
}
object DefaultWorkspaceCreationProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DefaultWorkspaceCreationProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspaces.model.DefaultWorkspaceCreationProperties =
      zio.aws.workspaces.model.DefaultWorkspaceCreationProperties(
        enableWorkDocs.map(value => value),
        enableInternetAccess.map(value => value),
        defaultOu.map(value => value),
        customSecurityGroupId.map(value => value),
        userEnabledAsLocalAdministrator.map(value => value),
        enableMaintenanceMode.map(value => value)
      )
    def enableWorkDocs: Option[BooleanObject]
    def enableInternetAccess: Option[BooleanObject]
    def defaultOu: Option[DefaultOu]
    def customSecurityGroupId: Option[SecurityGroupId]
    def userEnabledAsLocalAdministrator: Option[BooleanObject]
    def enableMaintenanceMode: Option[BooleanObject]
    def getEnableWorkDocs: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField("enableWorkDocs", enableWorkDocs)
    def getEnableInternetAccess: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField("enableInternetAccess", enableInternetAccess)
    def getDefaultOu: ZIO[Any, AwsError, DefaultOu] =
      AwsError.unwrapOptionField("defaultOu", defaultOu)
    def getCustomSecurityGroupId: ZIO[Any, AwsError, SecurityGroupId] =
      AwsError.unwrapOptionField("customSecurityGroupId", customSecurityGroupId)
    def getUserEnabledAsLocalAdministrator: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField(
        "userEnabledAsLocalAdministrator",
        userEnabledAsLocalAdministrator
      )
    def getEnableMaintenanceMode: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField("enableMaintenanceMode", enableMaintenanceMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DefaultWorkspaceCreationProperties
  ) extends zio.aws.workspaces.model.DefaultWorkspaceCreationProperties.ReadOnly {
    override val enableWorkDocs: Option[BooleanObject] = scala
      .Option(impl.enableWorkDocs())
      .map(value => zio.aws.workspaces.model.primitives.BooleanObject(value))
    override val enableInternetAccess: Option[BooleanObject] = scala
      .Option(impl.enableInternetAccess())
      .map(value => zio.aws.workspaces.model.primitives.BooleanObject(value))
    override val defaultOu: Option[DefaultOu] = scala
      .Option(impl.defaultOu())
      .map(value => zio.aws.workspaces.model.primitives.DefaultOu(value))
    override val customSecurityGroupId: Option[SecurityGroupId] = scala
      .Option(impl.customSecurityGroupId())
      .map(value => zio.aws.workspaces.model.primitives.SecurityGroupId(value))
    override val userEnabledAsLocalAdministrator: Option[BooleanObject] = scala
      .Option(impl.userEnabledAsLocalAdministrator())
      .map(value => zio.aws.workspaces.model.primitives.BooleanObject(value))
    override val enableMaintenanceMode: Option[BooleanObject] = scala
      .Option(impl.enableMaintenanceMode())
      .map(value => zio.aws.workspaces.model.primitives.BooleanObject(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DefaultWorkspaceCreationProperties
  ): zio.aws.workspaces.model.DefaultWorkspaceCreationProperties.ReadOnly =
    new Wrapper(impl)
}
