package zio.aws.workspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateWorkspaceBundleResponse(
    workspaceBundle: Option[zio.aws.workspaces.model.WorkspaceBundle] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.CreateWorkspaceBundleResponse = {
    import CreateWorkspaceBundleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.CreateWorkspaceBundleResponse
      .builder()
      .optionallyWith(workspaceBundle.map(value => value.buildAwsValue()))(
        _.workspaceBundle
      )
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.CreateWorkspaceBundleResponse.ReadOnly =
    zio.aws.workspaces.model.CreateWorkspaceBundleResponse.wrap(buildAwsValue())
}
object CreateWorkspaceBundleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.CreateWorkspaceBundleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.CreateWorkspaceBundleResponse =
      zio.aws.workspaces.model.CreateWorkspaceBundleResponse(
        workspaceBundle.map(value => value.asEditable)
      )
    def workspaceBundle
        : Option[zio.aws.workspaces.model.WorkspaceBundle.ReadOnly]
    def getWorkspaceBundle: ZIO[
      Any,
      AwsError,
      zio.aws.workspaces.model.WorkspaceBundle.ReadOnly
    ] = AwsError.unwrapOptionField("workspaceBundle", workspaceBundle)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.CreateWorkspaceBundleResponse
  ) extends zio.aws.workspaces.model.CreateWorkspaceBundleResponse.ReadOnly {
    override val workspaceBundle
        : Option[zio.aws.workspaces.model.WorkspaceBundle.ReadOnly] = scala
      .Option(impl.workspaceBundle())
      .map(value => zio.aws.workspaces.model.WorkspaceBundle.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.CreateWorkspaceBundleResponse
  ): zio.aws.workspaces.model.CreateWorkspaceBundleResponse.ReadOnly =
    new Wrapper(impl)
}
