package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{
  Region,
  WorkspaceImageId,
  WorkspaceImageDescription,
  WorkspaceImageName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CopyWorkspaceImageRequest(
    name: WorkspaceImageName,
    description: Option[WorkspaceImageDescription] = None,
    sourceImageId: WorkspaceImageId,
    sourceRegion: Region,
    tags: Option[Iterable[zio.aws.workspaces.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.CopyWorkspaceImageRequest = {
    import CopyWorkspaceImageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.CopyWorkspaceImageRequest
      .builder()
      .name(WorkspaceImageName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          WorkspaceImageDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .sourceImageId(WorkspaceImageId.unwrap(sourceImageId): java.lang.String)
      .sourceRegion(Region.unwrap(sourceRegion): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.CopyWorkspaceImageRequest.ReadOnly =
    zio.aws.workspaces.model.CopyWorkspaceImageRequest.wrap(buildAwsValue())
}
object CopyWorkspaceImageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.CopyWorkspaceImageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.CopyWorkspaceImageRequest =
      zio.aws.workspaces.model.CopyWorkspaceImageRequest(
        name,
        description.map(value => value),
        sourceImageId,
        sourceRegion,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: WorkspaceImageName
    def description: Option[WorkspaceImageDescription]
    def sourceImageId: WorkspaceImageId
    def sourceRegion: Region
    def tags: Option[List[zio.aws.workspaces.model.Tag.ReadOnly]]
    def getName: ZIO[Any, Nothing, WorkspaceImageName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, WorkspaceImageDescription] =
      AwsError.unwrapOptionField("description", description)
    def getSourceImageId: ZIO[Any, Nothing, WorkspaceImageId] =
      ZIO.succeed(sourceImageId)
    def getSourceRegion: ZIO[Any, Nothing, Region] = ZIO.succeed(sourceRegion)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.workspaces.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.CopyWorkspaceImageRequest
  ) extends zio.aws.workspaces.model.CopyWorkspaceImageRequest.ReadOnly {
    override val name: WorkspaceImageName =
      zio.aws.workspaces.model.primitives.WorkspaceImageName(impl.name())
    override val description: Option[WorkspaceImageDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.workspaces.model.primitives.WorkspaceImageDescription(value)
      )
    override val sourceImageId: WorkspaceImageId =
      zio.aws.workspaces.model.primitives.WorkspaceImageId(impl.sourceImageId())
    override val sourceRegion: Region =
      zio.aws.workspaces.model.primitives.Region(impl.sourceRegion())
    override val tags: Option[List[zio.aws.workspaces.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspaces.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.CopyWorkspaceImageRequest
  ): zio.aws.workspaces.model.CopyWorkspaceImageRequest.ReadOnly = new Wrapper(
    impl
  )
}
