package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{
  ConnectionIdentifier,
  NonEmptyString,
  AwsAccount
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ConnectionAliasAssociation(
    associationStatus: Option[zio.aws.workspaces.model.AssociationStatus] =
      None,
    associatedAccountId: Option[AwsAccount] = None,
    resourceId: Option[NonEmptyString] = None,
    connectionIdentifier: Option[ConnectionIdentifier] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.ConnectionAliasAssociation = {
    import ConnectionAliasAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.ConnectionAliasAssociation
      .builder()
      .optionallyWith(associationStatus.map(value => value.unwrap))(
        _.associationStatus
      )
      .optionallyWith(
        associatedAccountId.map(value =>
          AwsAccount.unwrap(value): java.lang.String
        )
      )(_.associatedAccountId)
      .optionallyWith(
        resourceId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.resourceId)
      .optionallyWith(
        connectionIdentifier.map(value =>
          ConnectionIdentifier.unwrap(value): java.lang.String
        )
      )(_.connectionIdentifier)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.ConnectionAliasAssociation.ReadOnly =
    zio.aws.workspaces.model.ConnectionAliasAssociation.wrap(buildAwsValue())
}
object ConnectionAliasAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.ConnectionAliasAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.ConnectionAliasAssociation =
      zio.aws.workspaces.model.ConnectionAliasAssociation(
        associationStatus.map(value => value),
        associatedAccountId.map(value => value),
        resourceId.map(value => value),
        connectionIdentifier.map(value => value)
      )
    def associationStatus: Option[zio.aws.workspaces.model.AssociationStatus]
    def associatedAccountId: Option[AwsAccount]
    def resourceId: Option[NonEmptyString]
    def connectionIdentifier: Option[ConnectionIdentifier]
    def getAssociationStatus
        : ZIO[Any, AwsError, zio.aws.workspaces.model.AssociationStatus] =
      AwsError.unwrapOptionField("associationStatus", associationStatus)
    def getAssociatedAccountId: ZIO[Any, AwsError, AwsAccount] =
      AwsError.unwrapOptionField("associatedAccountId", associatedAccountId)
    def getResourceId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getConnectionIdentifier: ZIO[Any, AwsError, ConnectionIdentifier] =
      AwsError.unwrapOptionField("connectionIdentifier", connectionIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.ConnectionAliasAssociation
  ) extends zio.aws.workspaces.model.ConnectionAliasAssociation.ReadOnly {
    override val associationStatus
        : Option[zio.aws.workspaces.model.AssociationStatus] = scala
      .Option(impl.associationStatus())
      .map(value => zio.aws.workspaces.model.AssociationStatus.wrap(value))
    override val associatedAccountId: Option[AwsAccount] = scala
      .Option(impl.associatedAccountId())
      .map(value => zio.aws.workspaces.model.primitives.AwsAccount(value))
    override val resourceId: Option[NonEmptyString] = scala
      .Option(impl.resourceId())
      .map(value => zio.aws.workspaces.model.primitives.NonEmptyString(value))
    override val connectionIdentifier: Option[ConnectionIdentifier] = scala
      .Option(impl.connectionIdentifier())
      .map(value =>
        zio.aws.workspaces.model.primitives.ConnectionIdentifier(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.ConnectionAliasAssociation
  ): zio.aws.workspaces.model.ConnectionAliasAssociation.ReadOnly = new Wrapper(
    impl
  )
}
