package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{
  AwsAccount,
  ConnectionAliasId,
  ConnectionString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ConnectionAlias(
    connectionString: Option[ConnectionString] = None,
    aliasId: Option[ConnectionAliasId] = None,
    state: Option[zio.aws.workspaces.model.ConnectionAliasState] = None,
    ownerAccountId: Option[AwsAccount] = None,
    associations: Option[
      Iterable[zio.aws.workspaces.model.ConnectionAliasAssociation]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.ConnectionAlias = {
    import ConnectionAlias.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.ConnectionAlias
      .builder()
      .optionallyWith(
        connectionString.map(value =>
          ConnectionString.unwrap(value): java.lang.String
        )
      )(_.connectionString)
      .optionallyWith(
        aliasId.map(value => ConnectionAliasId.unwrap(value): java.lang.String)
      )(_.aliasId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        ownerAccountId.map(value => AwsAccount.unwrap(value): java.lang.String)
      )(_.ownerAccountId)
      .optionallyWith(
        associations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.associations)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.ConnectionAlias.ReadOnly =
    zio.aws.workspaces.model.ConnectionAlias.wrap(buildAwsValue())
}
object ConnectionAlias {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.ConnectionAlias
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.ConnectionAlias =
      zio.aws.workspaces.model.ConnectionAlias(
        connectionString.map(value => value),
        aliasId.map(value => value),
        state.map(value => value),
        ownerAccountId.map(value => value),
        associations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def connectionString: Option[ConnectionString]
    def aliasId: Option[ConnectionAliasId]
    def state: Option[zio.aws.workspaces.model.ConnectionAliasState]
    def ownerAccountId: Option[AwsAccount]
    def associations: Option[
      List[zio.aws.workspaces.model.ConnectionAliasAssociation.ReadOnly]
    ]
    def getConnectionString: ZIO[Any, AwsError, ConnectionString] =
      AwsError.unwrapOptionField("connectionString", connectionString)
    def getAliasId: ZIO[Any, AwsError, ConnectionAliasId] =
      AwsError.unwrapOptionField("aliasId", aliasId)
    def getState
        : ZIO[Any, AwsError, zio.aws.workspaces.model.ConnectionAliasState] =
      AwsError.unwrapOptionField("state", state)
    def getOwnerAccountId: ZIO[Any, AwsError, AwsAccount] =
      AwsError.unwrapOptionField("ownerAccountId", ownerAccountId)
    def getAssociations: ZIO[Any, AwsError, List[
      zio.aws.workspaces.model.ConnectionAliasAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField("associations", associations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.ConnectionAlias
  ) extends zio.aws.workspaces.model.ConnectionAlias.ReadOnly {
    override val connectionString: Option[ConnectionString] = scala
      .Option(impl.connectionString())
      .map(value => zio.aws.workspaces.model.primitives.ConnectionString(value))
    override val aliasId: Option[ConnectionAliasId] = scala
      .Option(impl.aliasId())
      .map(value =>
        zio.aws.workspaces.model.primitives.ConnectionAliasId(value)
      )
    override val state: Option[zio.aws.workspaces.model.ConnectionAliasState] =
      scala
        .Option(impl.state())
        .map(value => zio.aws.workspaces.model.ConnectionAliasState.wrap(value))
    override val ownerAccountId: Option[AwsAccount] = scala
      .Option(impl.ownerAccountId())
      .map(value => zio.aws.workspaces.model.primitives.AwsAccount(value))
    override val associations: Option[
      List[zio.aws.workspaces.model.ConnectionAliasAssociation.ReadOnly]
    ] = scala
      .Option(impl.associations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workspaces.model.ConnectionAliasAssociation.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.ConnectionAlias
  ): zio.aws.workspaces.model.ConnectionAlias.ReadOnly = new Wrapper(impl)
}
