package zio.aws.workspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ComputeType(
    name: Option[zio.aws.workspaces.model.Compute] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.ComputeType = {
    import ComputeType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.ComputeType
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.ComputeType.ReadOnly =
    zio.aws.workspaces.model.ComputeType.wrap(buildAwsValue())
}
object ComputeType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.ComputeType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.ComputeType =
      zio.aws.workspaces.model.ComputeType(name.map(value => value))
    def name: Option[zio.aws.workspaces.model.Compute]
    def getName: ZIO[Any, AwsError, zio.aws.workspaces.model.Compute] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.ComputeType
  ) extends zio.aws.workspaces.model.ComputeType.ReadOnly {
    override val name: Option[zio.aws.workspaces.model.Compute] = scala
      .Option(impl.name())
      .map(value => zio.aws.workspaces.model.Compute.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.ComputeType
  ): zio.aws.workspaces.model.ComputeType.ReadOnly = new Wrapper(impl)
}
