package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ClientPropertiesResult(
    resourceId: Option[NonEmptyString] = None,
    clientProperties: Option[zio.aws.workspaces.model.ClientProperties] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.ClientPropertiesResult = {
    import ClientPropertiesResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.ClientPropertiesResult
      .builder()
      .optionallyWith(
        resourceId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.resourceId)
      .optionallyWith(clientProperties.map(value => value.buildAwsValue()))(
        _.clientProperties
      )
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.ClientPropertiesResult.ReadOnly =
    zio.aws.workspaces.model.ClientPropertiesResult.wrap(buildAwsValue())
}
object ClientPropertiesResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.ClientPropertiesResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.ClientPropertiesResult =
      zio.aws.workspaces.model.ClientPropertiesResult(
        resourceId.map(value => value),
        clientProperties.map(value => value.asEditable)
      )
    def resourceId: Option[NonEmptyString]
    def clientProperties
        : Option[zio.aws.workspaces.model.ClientProperties.ReadOnly]
    def getResourceId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getClientProperties: ZIO[
      Any,
      AwsError,
      zio.aws.workspaces.model.ClientProperties.ReadOnly
    ] = AwsError.unwrapOptionField("clientProperties", clientProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.ClientPropertiesResult
  ) extends zio.aws.workspaces.model.ClientPropertiesResult.ReadOnly {
    override val resourceId: Option[NonEmptyString] = scala
      .Option(impl.resourceId())
      .map(value => zio.aws.workspaces.model.primitives.NonEmptyString(value))
    override val clientProperties
        : Option[zio.aws.workspaces.model.ClientProperties.ReadOnly] = scala
      .Option(impl.clientProperties())
      .map(value => zio.aws.workspaces.model.ClientProperties.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.ClientPropertiesResult
  ): zio.aws.workspaces.model.ClientPropertiesResult.ReadOnly = new Wrapper(
    impl
  )
}
