package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{
  DirectoryId,
  VolumeEncryptionKey,
  WorkspaceId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StandbyWorkspace(
    primaryWorkspaceId: WorkspaceId,
    volumeEncryptionKey: Optional[VolumeEncryptionKey] = Optional.Absent,
    directoryId: DirectoryId,
    tags: Optional[Iterable[zio.aws.workspaces.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.StandbyWorkspace = {
    import StandbyWorkspace.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.StandbyWorkspace
      .builder()
      .primaryWorkspaceId(
        WorkspaceId.unwrap(primaryWorkspaceId): java.lang.String
      )
      .optionallyWith(
        volumeEncryptionKey.map(value =>
          VolumeEncryptionKey.unwrap(value): java.lang.String
        )
      )(_.volumeEncryptionKey)
      .directoryId(DirectoryId.unwrap(directoryId): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.StandbyWorkspace.ReadOnly =
    zio.aws.workspaces.model.StandbyWorkspace.wrap(buildAwsValue())
}
object StandbyWorkspace {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.StandbyWorkspace
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.StandbyWorkspace =
      zio.aws.workspaces.model.StandbyWorkspace(
        primaryWorkspaceId,
        volumeEncryptionKey.map(value => value),
        directoryId,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def primaryWorkspaceId: WorkspaceId
    def volumeEncryptionKey: Optional[VolumeEncryptionKey]
    def directoryId: DirectoryId
    def tags: Optional[List[zio.aws.workspaces.model.Tag.ReadOnly]]
    def getPrimaryWorkspaceId: ZIO[Any, Nothing, WorkspaceId] =
      ZIO.succeed(primaryWorkspaceId)
    def getVolumeEncryptionKey: ZIO[Any, AwsError, VolumeEncryptionKey] =
      AwsError.unwrapOptionField("volumeEncryptionKey", volumeEncryptionKey)
    def getDirectoryId: ZIO[Any, Nothing, DirectoryId] =
      ZIO.succeed(directoryId)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.workspaces.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.StandbyWorkspace
  ) extends zio.aws.workspaces.model.StandbyWorkspace.ReadOnly {
    override val primaryWorkspaceId: WorkspaceId =
      zio.aws.workspaces.model.primitives.WorkspaceId(impl.primaryWorkspaceId())
    override val volumeEncryptionKey: Optional[VolumeEncryptionKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volumeEncryptionKey())
        .map(value =>
          zio.aws.workspaces.model.primitives.VolumeEncryptionKey(value)
        )
    override val directoryId: DirectoryId =
      zio.aws.workspaces.model.primitives.DirectoryId(impl.directoryId())
    override val tags: Optional[List[zio.aws.workspaces.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspaces.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.StandbyWorkspace
  ): zio.aws.workspaces.model.StandbyWorkspace.ReadOnly = new Wrapper(impl)
}
