package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RootStorage(
    capacity: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.RootStorage = {
    import RootStorage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.RootStorage
      .builder()
      .optionallyWith(
        capacity.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.capacity)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.RootStorage.ReadOnly =
    zio.aws.workspaces.model.RootStorage.wrap(buildAwsValue())
}
object RootStorage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.RootStorage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.RootStorage =
      zio.aws.workspaces.model.RootStorage(capacity.map(value => value))
    def capacity: Optional[NonEmptyString]
    def getCapacity: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("capacity", capacity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.RootStorage
  ) extends zio.aws.workspaces.model.RootStorage.ReadOnly {
    override val capacity: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.capacity())
      .map(value => zio.aws.workspaces.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.RootStorage
  ): zio.aws.workspaces.model.RootStorage.ReadOnly = new Wrapper(impl)
}
