package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.DirectoryId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyCertificateBasedAuthPropertiesRequest(
    resourceId: DirectoryId,
    certificateBasedAuthProperties: Optional[
      zio.aws.workspaces.model.CertificateBasedAuthProperties
    ] = Optional.Absent,
    propertiesToDelete: Optional[
      Iterable[zio.aws.workspaces.model.DeletableCertificateBasedAuthProperty]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.ModifyCertificateBasedAuthPropertiesRequest = {
    import ModifyCertificateBasedAuthPropertiesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.ModifyCertificateBasedAuthPropertiesRequest
      .builder()
      .resourceId(DirectoryId.unwrap(resourceId): java.lang.String)
      .optionallyWith(
        certificateBasedAuthProperties.map(value => value.buildAwsValue())
      )(_.certificateBasedAuthProperties)
      .optionallyWith(
        propertiesToDelete.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.propertiesToDeleteWithStrings)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.ModifyCertificateBasedAuthPropertiesRequest.ReadOnly =
    zio.aws.workspaces.model.ModifyCertificateBasedAuthPropertiesRequest
      .wrap(buildAwsValue())
}
object ModifyCertificateBasedAuthPropertiesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.ModifyCertificateBasedAuthPropertiesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspaces.model.ModifyCertificateBasedAuthPropertiesRequest =
      zio.aws.workspaces.model.ModifyCertificateBasedAuthPropertiesRequest(
        resourceId,
        certificateBasedAuthProperties.map(value => value.asEditable),
        propertiesToDelete.map(value => value)
      )
    def resourceId: DirectoryId
    def certificateBasedAuthProperties: Optional[
      zio.aws.workspaces.model.CertificateBasedAuthProperties.ReadOnly
    ]
    def propertiesToDelete: Optional[
      List[zio.aws.workspaces.model.DeletableCertificateBasedAuthProperty]
    ]
    def getResourceId: ZIO[Any, Nothing, DirectoryId] = ZIO.succeed(resourceId)
    def getCertificateBasedAuthProperties: ZIO[
      Any,
      AwsError,
      zio.aws.workspaces.model.CertificateBasedAuthProperties.ReadOnly
    ] = AwsError.unwrapOptionField(
      "certificateBasedAuthProperties",
      certificateBasedAuthProperties
    )
    def getPropertiesToDelete: ZIO[Any, AwsError, List[
      zio.aws.workspaces.model.DeletableCertificateBasedAuthProperty
    ]] = AwsError.unwrapOptionField("propertiesToDelete", propertiesToDelete)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.ModifyCertificateBasedAuthPropertiesRequest
  ) extends zio.aws.workspaces.model.ModifyCertificateBasedAuthPropertiesRequest.ReadOnly {
    override val resourceId: DirectoryId =
      zio.aws.workspaces.model.primitives.DirectoryId(impl.resourceId())
    override val certificateBasedAuthProperties: Optional[
      zio.aws.workspaces.model.CertificateBasedAuthProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateBasedAuthProperties())
      .map(value =>
        zio.aws.workspaces.model.CertificateBasedAuthProperties.wrap(value)
      )
    override val propertiesToDelete: Optional[
      List[zio.aws.workspaces.model.DeletableCertificateBasedAuthProperty]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.propertiesToDelete())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workspaces.model.DeletableCertificateBasedAuthProperty
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.ModifyCertificateBasedAuthPropertiesRequest
  ): zio.aws.workspaces.model.ModifyCertificateBasedAuthPropertiesRequest.ReadOnly =
    new Wrapper(impl)
}
